/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.documentview.ui.internal.viewpoint.prototype;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.model2doc.documentview.Document;
import org.eclipse.papyrus.model2doc.documentview.representation.PapyrusDocument;
import org.eclipse.papyrus.model2doc.documentview.ui.menu.handler.CreateDocumentViewEditorHandler;

public class PapyrusDocumentViewPrototype
extends ViewPrototype {
    private final CreateDocumentViewEditorHandler command;

    public PapyrusDocumentViewPrototype(PapyrusDocument prototype, CreateDocumentViewEditorHandler command) {
        super((PapyrusRepresentationKind)prototype);
        this.command = command;
    }

    public boolean isOwnerReassignable() {
        return true;
    }

    public boolean instantiateOn(EObject owner) {
        return this.instantiateOn(owner, null);
    }

    public boolean instantiateOn(EObject owner, String name) {
        return this.command.execute(this, owner, name);
    }

    public Command getCommandChangeOwner(EObject view, final EObject target) {
        final Document document = (Document)view;
        final EObject previous = document.getContext();
        return new AbstractCommand("Change document onwer element"){

            public void execute() {
                document.setOwner(target);
            }

            public void undo() {
                document.setOwner(previous);
            }

            public void redo() {
                document.setOwner(target);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public Command getCommandChangeRoot(EObject view, final EObject target) {
        final Document document = (Document)view;
        final EObject previous = document.getContext();
        return new AbstractCommand("Change document root element"){

            public void execute() {
                document.setContext(target);
            }

            public void undo() {
                document.setContext(previous);
            }

            public void redo() {
                document.setContext(target);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public EObject getOwnerOf(EObject view) {
        return ((Document)view).getOwner();
    }

    public EObject getRootOf(EObject view) {
        return ((Document)view).getContext();
    }
}

