/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.handler;

import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.transcription.Transcription;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.odt.editor.StyleEditor;
import org.eclipse.papyrus.model2doc.odt.emf.structure2document.Activator;
import org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.transcriber.StructureToODTTranscriber;
import org.eclipse.papyrus.model2doc.odt.internal.editor.DefaultStyleEditor;
import org.eclipse.papyrus.model2doc.odt.internal.transcription.ODTTranscription;

public class CreateODTFileFromTextDocumentHelper {
    private TextDocument textDocument;

    protected CreateODTFileFromTextDocumentHelper() {
    }

    public CreateODTFileFromTextDocumentHelper(TextDocument textDocument) {
        this.setTextDocument(textDocument);
    }

    public void generate() {
        if (this.textDocument == null) {
            Activator.log.warn("The TextDocument is null");
            return;
        }
        IDocumentGeneratorConfiguration ddgc = this.textDocument.getDocumentGeneratorConfiguration();
        DefaultStyleEditor styleEditor = new DefaultStyleEditor();
        ODTTranscription transcription = new ODTTranscription((StyleEditor)styleEditor, ddgc);
        StructureToODTTranscriber t = new StructureToODTTranscriber(this.textDocument, (Transcription)transcription);
        t.transcribe();
    }

    protected void setTextDocument(TextDocument textDocument) {
        this.textDocument = textDocument;
    }
}

