/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.editor;

import com.sun.star.awt.FontSlant;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import org.eclipse.papyrus.model2doc.odt.editor.StyleEditor;
import org.eclipse.papyrus.model2doc.odt.service.StyleService;
import org.eclipse.papyrus.model2doc.odt.service.StyleServiceImpl;

public class DefaultStyleEditor
implements StyleEditor {
    private static final int MAX_SECTION_LEVEL = 10;
    private StyleService styleService = new StyleServiceImpl();

    @Override
    public void applyMainTitleStyle(XText text) {
        this.styleService.applyStyle(text, this.styleService.getParaStyleNamePropertyName(), this.styleService.getTitleStyleValue());
    }

    @Override
    public void applySectionTitleStyle(XTextCursor cursor, int sectionLevel) {
        if (sectionLevel <= 10) {
            this.styleService.applyStylePreviousParagraph(cursor, this.styleService.getParaStyleNamePropertyName(), String.valueOf(this.styleService.getHeadingStyleValue()) + " " + sectionLevel);
        }
    }

    @Override
    public void applyListStyle(XTextCursor cursor, int cursorStartPosition) {
        this.styleService.applyStyleLeft(cursor, cursorStartPosition, this.styleService.getNumberStyleNamePropertyName(), this.styleService.getList1StyleValue());
    }

    @Override
    public void applyImageStyle(XTextCursor cursor) {
        this.styleService.applyStylePreviousParagraph(cursor, this.styleService.getParaAdjustPropertyName(), ParagraphAdjust.CENTER);
    }

    @Override
    public void applyImageSubtitleStyle(XTextCursor cursor) {
        this.styleService.applyStylePreviousParagraph(cursor, this.styleService.getParaAdjustPropertyName(), ParagraphAdjust.CENTER);
        this.styleService.applyStylePreviousParagraph(cursor, this.styleService.getCharPorturePropertyName(), FontSlant.ITALIC);
    }
}

