/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.onefile.file;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.ISubResourceFile;

public abstract class GeneratedDocumentSubResourceFile
implements ISubResourceFile {
    private IPapyrusFile parent;
    private final IFile subResource;

    public GeneratedDocumentSubResourceFile(IPapyrusFile papyrusFile, IFile file) {
        this.parent = papyrusFile;
        this.subResource = file;
    }

    public IProject getProject() {
        return this.subResource.getProject();
    }

    public String toString() {
        String result = this.subResource.getName();
        String fileExtension = this.subResource.getFileExtension();
        if (fileExtension != null) {
            String resourceWithoutExtension;
            result = fileExtension;
            if (fileExtension.equals("properties")) {
                String resourceWithoutExtension2 = this.subResource.getName().substring(0, this.subResource.getName().lastIndexOf(46));
                if (!resourceWithoutExtension2.equals(this.parent.getText())) {
                    result = this.subResource.getName().substring(this.parent.getText().length());
                }
            } else if (this.isExtensionOfGeneratedDocument(fileExtension) && !(resourceWithoutExtension = this.subResource.getName().substring(0, this.subResource.getName().lastIndexOf(46))).equals(this.parent.getText())) {
                result = this.subResource.getName().substring(this.parent.getText().length());
            }
        }
        return result;
    }

    public IFile getFile() {
        return this.subResource;
    }

    public String getText() {
        return this.toString();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPapyrusFile getParent() {
        return this.parent;
    }

    protected abstract boolean isExtensionOfGeneratedDocument(String var1);
}

