/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.webapp.webapp24;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpMethodTypeBase implements Enumerator
{
    GET(0, "GET", "GET"),
    POST(1, "POST", "POST"),
    PUT(2, "PUT", "PUT"),
    DELETE(3, "DELETE", "DELETE"),
    HEAD(4, "HEAD", "HEAD"),
    OPTIONS(5, "OPTIONS", "OPTIONS"),
    TRACE(6, "TRACE", "TRACE");

    public static final int GET_VALUE = 0;
    public static final int POST_VALUE = 1;
    public static final int PUT_VALUE = 2;
    public static final int DELETE_VALUE = 3;
    public static final int HEAD_VALUE = 4;
    public static final int OPTIONS_VALUE = 5;
    public static final int TRACE_VALUE = 6;
    private static final HttpMethodTypeBase[] VALUES_ARRAY;
    public static final List<HttpMethodTypeBase> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HttpMethodTypeBase[]{GET, POST, PUT, DELETE, HEAD, OPTIONS, TRACE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HttpMethodTypeBase get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HttpMethodTypeBase result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HttpMethodTypeBase getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HttpMethodTypeBase result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HttpMethodTypeBase get(int value) {
        switch (value) {
            case 0: {
                return GET;
            }
            case 1: {
                return POST;
            }
            case 2: {
                return PUT;
            }
            case 3: {
                return DELETE;
            }
            case 4: {
                return HEAD;
            }
            case 5: {
                return OPTIONS;
            }
            case 6: {
                return TRACE;
            }
        }
        return null;
    }

    private HttpMethodTypeBase(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

