/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.graphics;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.draw2d.Graphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.FontRegistry;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

public class PrinterGraphics
extends org.eclipse.draw2d.PrinterGraphics {
    private double printScale = 1.0;
    private boolean roundFonts = false;
    private Stack stateStack = new Stack();
    Map<Image, Image> collapseImageCache = new HashMap<Image, Image>();

    protected double getPrintScale() {
        return this.printScale;
    }

    public PrinterGraphics(Graphics g, Printer p, boolean roundFonts) {
        super(g, p);
        this.roundFonts = roundFonts;
    }

    public void dispose() {
        for (Image img : this.collapseImageCache.values()) {
            img.dispose();
        }
        this.collapseImageCache.clear();
        super.dispose();
    }

    private Image collapseImage(Image srcImage) {
        Image result = this.collapseImageCache.get(srcImage);
        if (result != null) {
            return result;
        }
        Rectangle r1 = srcImage.getBounds();
        Image newImg = new Image(null, r1.width, r1.height);
        GC gc = new GC((Drawable)newImg);
        gc.setForeground(this.getForegroundColor());
        gc.setBackground(this.getBackgroundColor());
        gc.drawImage(srcImage, 0, 0);
        gc.dispose();
        this.collapseImageCache.put(srcImage, newImg);
        return newImg;
    }

    public void drawImage(Image srcImage, int x, int y) {
        Image collapseImage = srcImage.getImageData().transparentPixel == -1 ? this.collapseImage(srcImage) : srcImage;
        super.drawImage(collapseImage, x, y);
    }

    public void drawImage(Image srcImage, int sx, int sy, int sw, int sh, int tx, int ty, int tw, int th) {
        Image collapseImage = srcImage.getImageData().transparentPixel == -1 ? this.collapseImage(srcImage) : srcImage;
        super.drawImage(collapseImage, sx, sy, sw, sh, tx, ty, tw, th);
    }

    public boolean shouldRoundFonts() {
        return this.roundFonts;
    }

    public void scale(double amount) {
        this.printScale *= amount;
        super.scale(amount);
    }

    public void popState() {
        if (!this.stateStack.isEmpty()) {
            this.printScale = (Double)this.stateStack.pop();
        }
        super.popState();
    }

    public void pushState() {
        this.stateStack.push(new Double(this.printScale));
        super.pushState();
    }

    public void restoreState() {
        if (!this.stateStack.isEmpty()) {
            this.printScale = (Double)this.stateStack.firstElement();
        }
        super.restoreState();
    }

    public void setFont(Font f) {
        Font newFont = f;
        if (this.shouldRoundFonts()) {
            FontData fd = f.getFontData()[0];
            int nAdjustedHeight = (int)((double)((float)fd.getHeight() - 0.5f) / this.getPrintScale() * this.getPrintScale());
            if (fd.getHeight() != nAdjustedHeight) {
                fd.setHeight(nAdjustedHeight);
                newFont = FontRegistry.getInstance().getFont(null, fd);
            }
        }
        super.setFont(newFont);
    }
}

