/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.layout.graph;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gmf.examples.runtime.diagram.layout.graph.AbstractGMFGraphDemo;
import org.eclipse.gmf.examples.runtime.diagram.layout.graph.GMFGraphTests;

public class GMFDirectedGraphDemo
extends AbstractGMFGraphDemo {
    protected String[] getGraphMethods() {
        Method[] methods = GMFGraphTests.class.getMethods();
        String[] methodNames = new String[methods.length];
        int nameIndex = 0;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getReturnType().equals(DirectedGraph.class)) {
                methodNames[nameIndex] = methods[i].getName();
                ++nameIndex;
            }
            ++i;
        }
        return methodNames;
    }

    protected IFigure getContents() {
        DirectedGraph graph = null;
        try {
            graph = (DirectedGraph)GMFGraphTests.class.getMethod(graphMethod, null).invoke(null, null);
        }
        catch (Exception e) {
            System.out.println("Could not build graph");
            e.printStackTrace();
        }
        Figure contents = GMFDirectedGraphDemo.buildGraph(graph);
        return contents;
    }

    public static void main(String[] args) {
        new GMFDirectedGraphDemo().run();
    }

    public static Figure buildGraph(DirectedGraph graph) {
        Panel contents = new Panel();
        contents.setBackgroundColor(ColorConstants.white);
        contents.setLayoutManager((LayoutManager)new XYLayout());
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            GMFDirectedGraphDemo.buildNodeFigure((Figure)contents, node);
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            GMFDirectedGraphDemo.buildEdgeFigure((Figure)contents, edge);
            ++i;
        }
        return contents;
    }

    static void buildEdgeFigure(Figure contents, Edge edge) {
        PolylineConnection conn = GMFDirectedGraphDemo.connection(edge);
        conn.setForegroundColor(ColorConstants.gray);
        PolygonDecoration dec = new PolygonDecoration();
        conn.setTargetDecoration((RotatableDecoration)dec);
        conn.setPoints(edge.getPoints());
        contents.add((IFigure)conn);
    }

    static PolylineConnection connection(Edge e) {
        PolylineConnection conn = new PolylineConnection();
        conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
        NodeList nodes = e.vNodes;
        if (nodes != null) {
            int i = 0;
            while (i < nodes.size()) {
                Node n = nodes.getNode(i);
                int x = n.x;
                int y = n.y;
                bends.add(new AbsoluteBendpoint(x, y));
                bends.add(new AbsoluteBendpoint(x, y + n.height));
                ++i;
            }
        }
        conn.setRoutingConstraint(bends);
        return conn;
    }
}

