/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.clipboard;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedMapModeGraphics;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiagramGenerator {
    private int image_margin = 0;
    private DiagramEditPart _dgrmEP;

    public DiagramGenerator(DiagramEditPart dgrmEP) {
        this._dgrmEP = dgrmEP;
        this.image_margin = this.getMapMode().DPtoLP(10);
    }

    protected DiagramEditPart getDiagramEditPart() {
        return this._dgrmEP;
    }

    protected abstract Graphics setUpGraphics(int var1, int var2);

    protected void disposeGraphics(Graphics g) {
        g.dispose();
    }

    protected abstract ImageDescriptor getImageDescriptor(Graphics var1);

    public final Image createAWTImageForDiagram() {
        List editparts = this.getDiagramEditPart().getPrimaryEditParts();
        return this.createAWTImageForParts(editparts);
    }

    public Image createAWTImageForParts(List editparts) {
        org.eclipse.swt.graphics.Rectangle diagramArea = this.calculateImageRectangle(editparts);
        return this.createAWTImageForParts(editparts, diagramArea);
    }

    public final ImageDescriptor createSWTImageDescriptorForDiagram() {
        List editparts = this.getDiagramEditPart().getPrimaryEditParts();
        return this.createSWTImageDescriptorForParts(editparts);
    }

    public final ImageDescriptor createSWTImageDescriptorForParts(List editparts) {
        org.eclipse.swt.graphics.Rectangle sourceRect = this.calculateImageRectangle(editparts);
        return this.createSWTImageDescriptorForParts(editparts, sourceRect);
    }

    protected IMapMode getMapMode() {
        IMapMode mm = MapModeUtil.getMapMode((IFigure)this.getDiagramEditPart().getFigure());
        return mm;
    }

    protected final void renderToGraphics(Graphics graphics, Point translateOffset, List editparts) {
        this.sortSelection(editparts);
        graphics.translate(-translateOffset.x, -translateOffset.y);
        graphics.pushState();
        LinkedList<Object> connectionsToPaint = new LinkedList<Object>();
        Map decorations = this.findDecorations(editparts);
        ListIterator editPartsItr = editparts.listIterator();
        while (editPartsItr.hasNext()) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)editPartsItr.next();
            if (editPart instanceof ConnectionEditPart) {
                connectionsToPaint.add(editPart);
                continue;
            }
            connectionsToPaint.addAll(this.findConnectionsToPaint(editPart));
            IFigure figure = editPart.getFigure();
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
        }
        decorations = this.findDecorations(connectionsToPaint);
        Iterator connItr = connectionsToPaint.iterator();
        while (connItr.hasNext()) {
            IFigure figure = ((GraphicalEditPart)connItr.next()).getFigure();
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
        }
    }

    private Collection<ConnectionEditPart> findConnectionsToPaint(IGraphicalEditPart editPart) {
        HashSet editParts = new HashSet();
        HashSet<ConnectionEditPart> connectionEPs = new HashSet<ConnectionEditPart>();
        HashSet<ConnectionEditPart> connectionsToPaint = new HashSet<ConnectionEditPart>();
        this.getNestedEditParts(editPart, editParts);
        Iterator editPartsItr = editParts.iterator();
        while (editPartsItr.hasNext()) {
            connectionEPs.addAll(this.getAllConnectionsFrom((GraphicalEditPart)editPartsItr.next()));
        }
        while (!connectionEPs.isEmpty()) {
            Stack<ConnectionEditPart> connectionsPath = new Stack<ConnectionEditPart>();
            ConnectionEditPart conn = (ConnectionEditPart)connectionEPs.iterator().next();
            connectionEPs.remove(conn);
            connectionsPath.add(conn);
            EditPart target = conn.getTarget();
            while (connectionEPs.contains(target)) {
                ConnectionEditPart targetConn = (ConnectionEditPart)target;
                connectionEPs.remove(targetConn);
                connectionsPath.add(targetConn);
                target = targetConn.getTarget();
            }
            if (!editParts.contains(target) && !connectionsToPaint.contains(target)) continue;
            connectionsToPaint.addAll(connectionsPath);
        }
        return connectionsToPaint;
    }

    private List<ConnectionEditPart> getAllConnectionsFrom(GraphicalEditPart ep) {
        LinkedList<ConnectionEditPart> connections = new LinkedList<ConnectionEditPart>();
        for (ConnectionEditPart sourceConn : ep.getSourceConnections()) {
            connections.add(sourceConn);
            connections.addAll(this.getAllConnectionsFrom((GraphicalEditPart)sourceConn));
        }
        return connections;
    }

    private void paintFigure(Graphics graphics, IFigure figure) {
        if (!figure.isVisible()) {
            return;
        }
        Rectangle relBounds = null;
        relBounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds().getCopy() : figure.getBounds().getCopy();
        Rectangle abBounds = relBounds.getCopy();
        this.translateToPrintableLayer(figure, (Translatable)abBounds);
        int transX = abBounds.x - relBounds.x;
        int transY = abBounds.y - relBounds.y;
        graphics.pushState();
        graphics.translate(transX, transY);
        figure.paint(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    private Map findDecorations(Collection editparts) {
        IGraphicalEditPart first;
        IFigure decorationLayer;
        Map figureMap = this.mapFiguresToEditParts(editparts);
        HashMap<IFigure, Object> result = new HashMap<IFigure, Object>();
        if (!editparts.isEmpty() && (decorationLayer = LayerManager.Helper.find((EditPart)(first = (IGraphicalEditPart)editparts.iterator().next())).getLayer((Object)"Decoration Printable Layer")) != null) {
            ArrayList figures = new ArrayList(editparts);
            Iterator iter = figures.listIterator();
            while (iter.hasNext()) {
                iter.set(((IGraphicalEditPart)iter.next()).getFigure());
            }
            block1: for (Object next : decorationLayer.getChildren()) {
                if (!(next instanceof Decoration)) continue;
                Decoration decoration = (Decoration)next;
                IFigure owner = decoration.getOwnerFigure();
                while (owner != null) {
                    if (figureMap.containsKey(owner)) {
                        Object existing = result.get(owner);
                        if (existing == null) {
                            result.put(owner, decoration);
                            continue block1;
                        }
                        if (existing instanceof Collection) {
                            ((Collection)existing).add(decoration);
                            continue block1;
                        }
                        ArrayList<Object> c = new ArrayList<Object>(2);
                        c.add(existing);
                        c.add(decoration);
                        result.put(owner, c);
                        continue block1;
                    }
                    owner = owner.getParent();
                }
            }
        }
        return result;
    }

    private Map mapFiguresToEditParts(Collection editParts) {
        HashMap<IFigure, IGraphicalEditPart> result = new HashMap<IFigure, IGraphicalEditPart>();
        for (IGraphicalEditPart next : editParts) {
            result.put(next.getFigure(), next);
        }
        return result;
    }

    private void paintDecorations(Graphics graphics, IFigure figure, Map decorations) {
        Object decoration = decorations.get(figure);
        if (decoration != null) {
            if (decoration instanceof Collection) {
                Iterator iter = ((Collection)decoration).iterator();
                while (iter.hasNext()) {
                    this.paintFigure(graphics, (IFigure)iter.next());
                }
            } else {
                this.paintFigure(graphics, (IFigure)decoration);
            }
        }
    }

    private void sortSelection(GraphicalEditPart editPart, List open, List closed) {
        if (open.isEmpty()) {
            return;
        }
        if (open.contains(editPart)) {
            closed.add(editPart);
            open.remove(editPart);
        }
        for (GraphicalEditPart child : editPart.getChildren()) {
            this.sortSelection(child, open, closed);
        }
    }

    private List sortSelection(List toSort) {
        ArrayList closed = new ArrayList(toSort.size());
        ArrayList open = new ArrayList(toSort.size());
        open.addAll(toSort);
        this.sortSelection((GraphicalEditPart)this.getDiagramEditPart(), open, closed);
        if (!open.isEmpty()) {
            closed.addAll(open);
        }
        return closed;
    }

    private void getNestedEditParts(IGraphicalEditPart childEditPart, Collection editParts) {
        for (IGraphicalEditPart child : childEditPart.getChildren()) {
            editParts.add(child);
            this.getNestedEditParts(child, editParts);
        }
    }

    public org.eclipse.swt.graphics.Rectangle calculateImageRectangle(List editparts) {
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        IMapMode mm = this.getMapMode();
        int i = 0;
        while (i < editparts.size()) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)editparts.get(i);
            IFigure figure = editPart.getFigure();
            Rectangle bounds = null;
            bounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds() : figure.getBounds().getCopy();
            this.translateToPrintableLayer(figure, (Translatable)bounds);
            bounds = bounds.getExpanded(this.getImageMargin(), this.getImageMargin());
            if (i == 0) {
                minX = bounds.x;
                maxX = bounds.x + bounds.width;
                minY = bounds.y;
                maxY = bounds.y + bounds.height;
            } else {
                minX = Math.min(minX, bounds.x);
                maxX = Math.max(maxX, bounds.x + bounds.width);
                minY = Math.min(minY, bounds.y);
                maxY = Math.max(maxY, bounds.y + bounds.height);
            }
            ++i;
        }
        int width = maxX - minX;
        int height = maxY - minY;
        if (width <= 0) {
            width = mm.DPtoLP(100);
        }
        if (height <= 0) {
            height = mm.DPtoLP(100);
        }
        org.eclipse.swt.graphics.Rectangle imageRect = new org.eclipse.swt.graphics.Rectangle(minX, minY, width, height);
        return imageRect;
    }

    public List getDiagramPartInfo() {
        Assert.isNotNull((Object)this._dgrmEP);
        return this.getDiagramPartInfo(this._dgrmEP);
    }

    public List getDiagramPartInfo(DiagramEditPart diagramEditPart) {
        ArrayList<PartPositionInfo> result = new ArrayList<PartPositionInfo>();
        ArrayList<IGraphicalEditPart> editParts = new ArrayList<IGraphicalEditPart>();
        List children = diagramEditPart.getPrimaryEditParts();
        IMapMode mm = this.getMapMode();
        org.eclipse.swt.graphics.Rectangle imageRect = this.calculateImageRectangle(children);
        for (IGraphicalEditPart part : children) {
            editParts.add(part);
            this.getNestedEditParts(part, editParts);
        }
        for (IGraphicalEditPart part : editParts) {
            PartPositionInfo position;
            IFigure figure = part.getFigure();
            if (part instanceof ShapeEditPart || part instanceof ShapeCompartmentEditPart) {
                position = new PartPositionInfo();
                position.setSemanticElement(ViewUtil.resolveSemanticElement((View)((View)part.getModel())));
                Rectangle bounds = figure.getBounds().getCopy();
                this.translateToPrintableLayer(figure, (Translatable)bounds);
                bounds.translate(-imageRect.x, -imageRect.y);
                position.setPartHeight(mm.LPtoDP(bounds.height));
                position.setPartWidth(mm.LPtoDP(bounds.width));
                position.setPartX(mm.LPtoDP(bounds.x));
                position.setPartY(mm.LPtoDP(bounds.y));
                result.add(0, position);
                continue;
            }
            if (!(part instanceof ConnectionEditPart)) continue;
            position = new PartPositionInfo();
            position.setSemanticElement(ViewUtil.resolveSemanticElement((View)((View)part.getModel())));
            if (!(figure instanceof PolylineConnection)) continue;
            PolylineConnection mainPoly = (PolylineConnection)figure;
            PointList mainPts = mainPoly.getPoints();
            this.translateToPrintableLayer(figure, (Translatable)mainPts);
            List<Point> envelopingPts = this.calculateEnvelopingPolyline(mainPts, new Point(imageRect.x, imageRect.y));
            List<Point> transformedPts = this.convertPolylineUnits(envelopingPts);
            position.setPolyline(transformedPts);
            result.add(0, position);
        }
        return result;
    }

    public List<PartPositionInfo> getConstrainedDiagramPartInfo(int maxWidth, int maxHeight, boolean useMargins) {
        return this.getConstrainedDiagramPartInfo(this._dgrmEP, maxWidth, maxHeight, useMargins);
    }

    public List<PartPositionInfo> getConstrainedDiagramPartInfo(DiagramEditPart diagramEditPart, int maxWidth, int maxHeight, boolean useMargins) {
        ArrayList<PartPositionInfo> result = new ArrayList<PartPositionInfo>();
        ArrayList<IGraphicalEditPart> editParts = new ArrayList<IGraphicalEditPart>();
        List children = diagramEditPart.getPrimaryEditParts();
        IMapMode mm = this.getMapMode();
        ConstrainedImageRenderingData data = this.getConstrainedImageRenderingData(children, maxWidth, maxHeight, useMargins);
        Rectangle imageRect = data.imageOriginalBounds.getCopy();
        mm.DPtoLP((Translatable)imageRect);
        if (useMargins) {
            imageRect.shrink(this.getImageMargin(), this.getImageMargin());
        }
        imageRect.performScale(data.scalingFactor);
        if (useMargins) {
            imageRect.expand(this.getImageMargin(), this.getImageMargin());
        }
        for (IGraphicalEditPart part : children) {
            editParts.add(part);
            this.getNestedEditParts(part, editParts);
        }
        for (IGraphicalEditPart part : editParts) {
            PartPositionInfo position;
            IFigure figure = part.getFigure();
            if (part instanceof ShapeEditPart || part instanceof ShapeCompartmentEditPart) {
                position = new PartPositionInfo();
                position.setSemanticElement(ViewUtil.resolveSemanticElement((View)((View)part.getModel())));
                Rectangle bounds = figure.getBounds().getCopy();
                this.translateToPrintableLayer(figure, (Translatable)bounds);
                bounds.performScale(data.scalingFactor);
                bounds.translate(-imageRect.x, -imageRect.y);
                position.setPartHeight(mm.LPtoDP(bounds.height));
                position.setPartWidth(mm.LPtoDP(bounds.width));
                position.setPartX(mm.LPtoDP(bounds.x));
                position.setPartY(mm.LPtoDP(bounds.y));
                result.add(0, position);
                continue;
            }
            if (!(part instanceof ConnectionEditPart)) continue;
            position = new PartPositionInfo();
            position.setSemanticElement(ViewUtil.resolveSemanticElement((View)((View)part.getModel())));
            if (!(figure instanceof PolylineConnection)) continue;
            PolylineConnection mainPoly = (PolylineConnection)figure;
            PointList mainPts = mainPoly.getPoints();
            mainPts.performScale(data.scalingFactor);
            this.translateToPrintableLayer(figure, (Translatable)mainPts);
            List<Point> envelopingPts = this.calculateEnvelopingPolyline(mainPts, new Point(imageRect.x, imageRect.y));
            List<Point> transformedPts = this.convertPolylineUnits(envelopingPts);
            position.setPolyline(transformedPts);
            result.add(0, position);
        }
        return result;
    }

    private void translateToPrintableLayer(IFigure figure, Translatable translatable) {
        IFigure printableLayer = this.getDiagramEditPart().getLayer((Object)"Printable Layers");
        if (figure == null || figure.equals(printableLayer)) {
            return;
        }
        figure.translateToParent(translatable);
        this.translateToPrintableLayer(figure.getParent(), translatable);
    }

    private List<Point> calculateEnvelopingPolyline(PointList polyPts, Point origin) {
        ArrayList<Point> result = new ArrayList<Point>();
        List mainSegs = PointListUtilities.getLineSegments((PointList)polyPts);
        int mainSegsLength = mainSegs.size();
        LineSeg segment = null;
        Point orthoPoint1 = null;
        Point orthoPoint2 = null;
        int i = 0;
        while (i < mainSegsLength) {
            segment = (LineSeg)mainSegs.get(i);
            orthoPoint1 = segment.locatePoint(0.0, (long)this.getImageMargin(), LineSeg.Sign.POSITIVE);
            orthoPoint1.translate(-origin.x, -origin.y);
            orthoPoint2 = segment.locatePoint(1.0, (long)this.getImageMargin(), LineSeg.Sign.POSITIVE);
            orthoPoint2.translate(-origin.x, -origin.y);
            result.add(orthoPoint1);
            result.add(orthoPoint2);
            ++i;
        }
        i = mainSegsLength - 1;
        while (i >= 0) {
            segment = (LineSeg)mainSegs.get(i);
            orthoPoint1 = segment.getTerminus();
            orthoPoint1.translate(-origin.x, -origin.y);
            result.add(orthoPoint1);
            orthoPoint2 = segment.getOrigin();
            orthoPoint2.translate(-origin.x, -origin.y);
            result.add(orthoPoint2);
            --i;
        }
        result.add((Point)result.get(0));
        return result;
    }

    private List<Point> convertPolylineUnits(List<Point> polyPts) {
        ArrayList<Point> result = new ArrayList<Point>();
        IMapMode mm = this.getMapMode();
        for (Point point : polyPts) {
            Point newPoint = new Point(mm.LPtoDP(point.x), mm.LPtoDP(point.y));
            result.add(newPoint);
        }
        return result;
    }

    protected int getImageMargin() {
        return this.image_margin;
    }

    public Image createAWTImageForParts(List editParts, org.eclipse.swt.graphics.Rectangle diagramArea) {
        return null;
    }

    public final ImageDescriptor createSWTImageDescriptorForParts(List editparts, org.eclipse.swt.graphics.Rectangle sourceRect) {
        ImageDescriptor imageDesc = new ImageDescriptor(){

            public ImageData getImageData() {
                return SharedImages.get((String)"icons/error.gif").getImageData();
            }
        };
        Graphics graphics = null;
        try {
            IMapMode mm = this.getMapMode();
            graphics = this.setUpGraphics(mm.LPtoDP(sourceRect.width), mm.LPtoDP(sourceRect.height));
            RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics(graphics, this.getMapMode());
            this.renderToGraphics((Graphics)mapModeGraphics, new Point(sourceRect.x, sourceRect.y), editparts);
            imageDesc = this.getImageDescriptor(graphics);
        }
        catch (Throwable throwable) {
            if (graphics != null) {
                this.disposeGraphics(graphics);
            }
            throw throwable;
        }
        if (graphics != null) {
            this.disposeGraphics(graphics);
        }
        return imageDesc;
    }

    public final ImageDescriptor createConstrainedSWTImageDecriptorForParts(List editParts, int maxDeviceWidth, int maxDeviceHeight, boolean useMargins) {
        ImageDescriptor imageDesc = new ImageDescriptor(){

            public ImageData getImageData() {
                return SharedImages.get((String)"icons/error.gif").getImageData();
            }
        };
        Graphics graphics = null;
        try {
            IMapMode mm = this.getMapMode();
            ConstrainedImageRenderingData data = this.getConstrainedImageRenderingData(editParts, maxDeviceWidth, maxDeviceHeight, useMargins);
            graphics = this.setUpGraphics(data.imageWidth, data.imageHeight);
            ScaledGraphics scaledGraphics = new ScaledGraphics(graphics);
            RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics((Graphics)scaledGraphics, this.getMapMode());
            graphics.translate(data.margin, data.margin);
            mapModeGraphics.scale(data.scalingFactor);
            PrecisionPoint location = new PrecisionPoint(data.imageOriginalBounds.preciseX(), data.imageOriginalBounds.preciseY());
            mm.DPtoLP((Translatable)location);
            this.renderToGraphics((Graphics)mapModeGraphics, (Point)location, editParts);
            imageDesc = this.getImageDescriptor(graphics);
        }
        catch (Throwable throwable) {
            if (graphics != null) {
                this.disposeGraphics(graphics);
            }
            throw throwable;
        }
        if (graphics != null) {
            this.disposeGraphics(graphics);
        }
        return imageDesc;
    }

    ConstrainedImageRenderingData getConstrainedImageRenderingData(List editParts, int maxDeviceWidth, int maxDeviceHeight, boolean useMargins) {
        double xScalingFactor;
        ConstrainedImageRenderingData data = new ConstrainedImageRenderingData();
        IMapMode mm = this.getMapMode();
        data.imageOriginalBounds = new PrecisionRectangle(new Rectangle(this.calculateImageRectangle(editParts)));
        mm.LPtoDP((Translatable)data.imageOriginalBounds);
        int deviceMargins = mm.LPtoDP(this.getImageMargin());
        data.margin = useMargins ? deviceMargins : 0;
        double yScalingFactor = xScalingFactor = 1.0;
        data.imageOriginalBounds.shrink(deviceMargins, deviceMargins);
        if (maxDeviceWidth > data.margin) {
            xScalingFactor = (double)(maxDeviceWidth - data.margin - data.margin) / data.imageOriginalBounds.preciseWidth();
        }
        if (maxDeviceHeight > data.margin) {
            yScalingFactor = (double)(maxDeviceHeight - data.margin - data.margin) / data.imageOriginalBounds.preciseHeight();
        }
        data.scalingFactor = Math.min(Math.min(xScalingFactor, yScalingFactor), 1.0);
        data.imageWidth = data.imageOriginalBounds.width + data.margin + data.margin;
        data.imageHeight = data.imageOriginalBounds.height + data.margin + data.margin;
        if (data.scalingFactor < 1.0) {
            data.imageWidth = (int)Math.round(data.imageOriginalBounds.preciseWidth() * data.scalingFactor) + data.margin + data.margin;
            data.imageHeight = (int)Math.round(data.imageOriginalBounds.preciseHeight() * data.scalingFactor) + data.margin + data.margin;
        } else {
            data.scalingFactor = 1.0;
        }
        return data;
    }

    public Image createConstrainedAWTImageForParts(List editParts, int maxDeviceWidth, int maxDeviceHeight, boolean useMargins) {
        return null;
    }

    class ConstrainedImageRenderingData {
        double scalingFactor;
        int imageWidth;
        int imageHeight;
        Rectangle imageOriginalBounds;
        int margin;

        ConstrainedImageRenderingData() {
        }
    }
}

