/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.gmf.internal.codegen.popup.actions.Messages;
import org.eclipse.gmf.internal.codegen.popup.actions.ValidationHelper;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

public class DiagnosticsDialog
extends IconAndMessageDialog {
    private static final int ITEM_COUNT = 7;
    private static final int STACK_TRACE_TEXT_LINE_COUNT = 3;
    private static final String NESTING_INDENT = "  ";
    private Button detailsButton;
    private String title;
    private TreeViewer diagnosticTree;
    private Text stackTraceText;
    private boolean detailsCreated = false;
    private Diagnostic rootDiagnotic;
    private Clipboard clipboard;
    private boolean shouldIncludeTopLevelErrorInDetails;
    private final String[] buttonLabels;
    private final int[] buttonIDs;
    private final int defaultButtonIndex;

    public DiagnosticsDialog(Shell parentShell, String dialogTitle, String dialogMessage, Diagnostic diagnostic, String[] dialogButtonLabels, int[] dialogButtonIDs, int defaultDialogButtonIndex) {
        super(parentShell);
        if (diagnostic == null) {
            throw new IllegalArgumentException("Null diagnostic");
        }
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = dialogMessage == null ? diagnostic.getMessage() : JFaceResources.format((String)"Reason", (Object[])new Object[]{dialogMessage, diagnostic.getMessage()});
        this.rootDiagnotic = diagnostic;
        this.shouldIncludeTopLevelErrorInDetails = true;
        assert (dialogButtonIDs != null && dialogButtonLabels != null);
        assert (dialogButtonIDs.length == dialogButtonLabels.length);
        assert (defaultDialogButtonIndex >= 0 && defaultDialogButtonIndex < dialogButtonIDs.length);
        this.buttonIDs = dialogButtonIDs;
        this.buttonLabels = dialogButtonLabels;
        this.defaultButtonIndex = defaultDialogButtonIndex;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else if (id == 0 || id == 1) {
            super.buttonPressed(id);
        } else {
            this.setReturnCode(id);
            this.close();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        int i = 0;
        while (i < this.buttonLabels.length) {
            this.createButton(parent, this.buttonIDs[i], this.buttonLabels[i], this.defaultButtonIndex == i);
            ++i;
        }
        this.createDetailsButton(parent);
    }

    protected void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        if (this.rootDiagnotic != null) {
            if (this.rootDiagnotic.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (this.rootDiagnotic.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    protected void createDropDownTree(Composite parent) {
        this.diagnosticTree = new TreeViewer(parent, 2816);
        GridData data = new GridData(1808);
        data.heightHint = this.diagnosticTree.getTree().getItemHeight() * 7;
        data.horizontalSpan = 2;
        this.diagnosticTree.getTree().setLayoutData((Object)data);
        this.diagnosticTree.getTree().setFont(parent.getFont());
        Menu copyMenu = this.createDiagnosticTreeMenu();
        this.diagnosticTree.getTree().setMenu(copyMenu);
        this.diagnosticTree.setLabelProvider((IBaseLabelProvider)new DiagnosticLabelProvider());
        this.diagnosticTree.setContentProvider((IContentProvider)new DiagnosticContentProvider(this.shouldIncludeTopLevelErrorInDetails));
        this.diagnosticTree.setInput((Object)this.rootDiagnotic);
        this.diagnosticTree.expandToLevel(2);
        this.diagnosticTree.setSelection((ISelection)new StructuredSelection((Object)this.rootDiagnotic), true);
        this.diagnosticTree.getTree().setFocus();
    }

    public static int openProceedCancel(Shell parentShell, String title, String message, Diagnostic rootDiagnostic) {
        return DiagnosticsDialog.openProceedCancel(parentShell, title, message, rootDiagnostic, false);
    }

    public static int openProceedCancel(Shell parentShell, String title, String message, Diagnostic rootDiagnostic, final boolean disableProceed) {
        DiagnosticsDialog dialog = new DiagnosticsDialog(parentShell, title, message, rootDiagnostic, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, new int[]{10, 1}, 0){

            protected Control createButtonBar(Composite parent) {
                Control buttonBar = super.createButtonBar(parent);
                Button proceedButton = this.getButton(10);
                if (!$assertionsDisabled && proceedButton == null) {
                    throw new AssertionError();
                }
                if (proceedButton != null) {
                    proceedButton.setEnabled(!disableProceed);
                }
                return buttonBar;
            }
        };
        return dialog.open();
    }

    public static int openOk(Shell parentShell, String title, String message, Diagnostic rootDiagnostic) {
        return new DiagnosticsDialog(parentShell, title, message, rootDiagnostic, new String[]{IDialogConstants.OK_LABEL}, new int[1], 0).open();
    }

    private Object getSelection() {
        ISelection selection;
        if (this.diagnosticTree != null && !this.diagnosticTree.getTree().isDisposed() && !(selection = this.diagnosticTree.getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.getFirstElement();
        }
        return null;
    }

    private Diagnostic getDiagnosticSelection() {
        Object selection = this.getSelection();
        return selection instanceof Diagnostic ? (Diagnostic)selection : null;
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.detailsCreated) {
            this.diagnosticTree.getTree().dispose();
            this.stackTraceText.dispose();
            this.detailsCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDetailsArea((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    private void populateCopyBuffer(Diagnostic buildingDiagnostic, StringBuffer buffer, int nesting) {
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING_INDENT);
            ++i;
        }
        buffer.append(buildingDiagnostic.getMessage());
        buffer.append(System.getProperty("line.separator", "\n"));
        Throwable t = buildingDiagnostic.getException();
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            this.populateCopyBuffer(BasicDiagnostic.toDiagnostic((Throwable)ce), buffer, nesting + 1);
        }
        List children = buildingDiagnostic.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            this.populateCopyBuffer((Diagnostic)it.next(), buffer, nesting + 1);
        }
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.detailsCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return !this.rootDiagnotic.getChildren().isEmpty() || this.rootDiagnotic.getException() != null;
    }

    private void createDetailsArea(Composite parent) {
        this.createDropDownTree(parent);
        this.createDropDownText(parent, this.diagnosticTree.getTree().getBackground());
        this.diagnosticTree.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Throwable throwable = DiagnosticsDialog.this.getExceptionSelection();
                String textValue = "";
                if (throwable != null) {
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(baos);
                        throwable.printStackTrace(ps);
                        ps.flush();
                        baos.flush();
                        textValue = baos.toString();
                    }
                    catch (IOException iOException) {}
                }
                DiagnosticsDialog.this.stackTraceText.setText(textValue);
            }
        });
        this.detailsCreated = true;
    }

    private void createDropDownText(Composite parent, Color backgroundColor) {
        this.stackTraceText = new Text(parent, 2824);
        this.stackTraceText.setBackground(backgroundColor);
        this.stackTraceText.setFont(parent.getFont());
        GridData data = new GridData(1808);
        data.heightHint = this.stackTraceText.getLineHeight() * 3;
        data.horizontalSpan = 2;
        this.stackTraceText.setLayoutData((Object)data);
        this.stackTraceText.setToolTipText(Messages.DiagnosticsDialog_exceptStackTrace_toolTip);
    }

    private Menu createDiagnosticTreeMenu() {
        Menu diagnosticMenu = new Menu((Control)this.diagnosticTree.getTree());
        MenuItem copyItem = new MenuItem(diagnosticMenu, 0);
        copyItem.setText(Messages.DiagnosticsDialog_Copy_menuItem);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagnosticsDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DiagnosticsDialog.this.copyToClipboard();
            }
        });
        if (ValidationHelper.getDiagnosticMarkerMap(this.rootDiagnotic) != null) {
            MenuItem gotoItem = new MenuItem(diagnosticMenu, 0);
            gotoItem.setText(Messages.DiagnosticsDialog_gotoProblem_menuItem);
            gotoItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DiagnosticsDialog.this.gotoProblem();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    DiagnosticsDialog.this.gotoProblem();
                }
            });
        }
        return diagnosticMenu;
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        StringBuffer statusBuffer = new StringBuffer();
        Diagnostic source = this.getDiagnosticSelection();
        this.populateCopyBuffer(source != null ? source : this.rootDiagnotic, statusBuffer, 0);
        this.clipboard = new Clipboard(this.getShell().getDisplay());
        this.clipboard.setContents(new Object[]{statusBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void gotoProblem() {
        IWorkbench workbench;
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage page;
        Diagnostic diagnostic = this.getDiagnosticSelection();
        if (diagnostic == null) {
            return;
        }
        ValidationHelper.DiagnosticMarkerMap markerMap = ValidationHelper.getDiagnosticMarkerMap(this.rootDiagnotic);
        IMarker marker = null;
        if (markerMap != null) {
            if (!markerMap.getMap().containsKey(diagnostic) && diagnostic == this.rootDiagnotic && !diagnostic.getChildren().isEmpty()) {
                diagnostic = (Diagnostic)diagnostic.getChildren().get(0);
            }
            marker = markerMap.getMap().get(diagnostic);
        }
        IWorkbenchPage iWorkbenchPage = page = (workbenchWindow = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null ? workbenchWindow.getActivePage() : null;
        if (page == null) {
            return;
        }
        try {
            page.showView("org.eclipse.ui.views.ProblemView");
        }
        catch (PartInitException e) {
            CodeGenUIPlugin.getDefault().getLog().log(e.getStatus());
        }
        IFile file = ValidationHelper.getFileFromDiagnostic(diagnostic);
        if (file != null) {
            try {
                IEditorDescriptor[] editorDescriptors;
                String editorId = "org.eclipse.ui.DefaultTextEditor";
                IEditorPart editorPart = null;
                if ((marker == null || marker.getAttribute("uri", null) != null) && (editorDescriptors = PlatformUI.getWorkbench().getEditorRegistry().getEditors(file.getName())).length > 0) {
                    editorId = editorDescriptors[0].getId();
                }
                editorPart = page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true, 3);
                IGotoMarker gotoMarkerSupport = null;
                if (editorPart != null) {
                    gotoMarkerSupport = (IGotoMarker)editorPart.getAdapter(IGotoMarker.class);
                    this.cancelPressed();
                }
                if (gotoMarkerSupport != null && marker != null) {
                    gotoMarkerSupport.gotoMarker(marker);
                }
            }
            catch (PartInitException e) {
                CodeGenUIPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private Throwable getExceptionSelection() {
        Diagnostic selection = this.getDiagnosticSelection();
        return selection != null ? selection.getException() : null;
    }

    static Diagnostic toDiagnostic(IStatus status) {
        Object[] data = null;
        if (status.getException() != null) {
            data = new Object[]{status.getException()};
        }
        List children = Collections.emptyList();
        if (status.isMultiStatus()) {
            IStatus[] nestedStatuses = status.getChildren();
            children = new ArrayList(nestedStatuses.length);
            int i = 0;
            while (i < nestedStatuses.length) {
                children.add(DiagnosticsDialog.toDiagnostic(nestedStatuses[i]));
                ++i;
            }
            return new BasicDiagnostic(status.getPlugin(), status.getCode(), children, status.getMessage(), data);
        }
        return new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), data);
    }

    private static class DiagnosticLabelProvider
    extends LabelProvider {
        private DiagnosticLabelProvider() {
        }

        public Image getImage(Object element) {
            if (!(element instanceof Diagnostic)) {
                return null;
            }
            Diagnostic diagnostic = (Diagnostic)element;
            String imageName = "IMG_OBJS_ERROR_TSK";
            switch (diagnostic.getSeverity()) {
                case 1: {
                    imageName = "IMG_OBJS_INFO_TSK";
                    break;
                }
                case 2: {
                    imageName = "IMG_OBJS_WARN_TSK";
                }
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
        }

        public String getText(Object element) {
            Diagnostic diagnostic;
            if (element instanceof Diagnostic && (diagnostic = (Diagnostic)element).getMessage() != null) {
                return diagnostic.getMessage();
            }
            return super.getText(element);
        }
    }

    private static class DiagnosticContentProvider
    implements ITreeContentProvider {
        Object cachedInput;
        boolean showTopLevel;

        DiagnosticContentProvider(boolean showTopLevelDiagnostic) {
            this.showTopLevel = showTopLevelDiagnostic;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Diagnostic) {
                Diagnostic diagnostic = (Diagnostic)parentElement;
                return diagnostic.getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Diagnostic) {
                Diagnostic diagnostic = (Diagnostic)element;
                return !diagnostic.getChildren().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Diagnostic) {
                Diagnostic diagnostic = (Diagnostic)inputElement;
                if (diagnostic == this.cachedInput && this.showTopLevel) {
                    this.cachedInput = null;
                    return new Object[]{diagnostic};
                }
                return diagnostic.getChildren().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.cachedInput = newInput;
        }
    }
}

