/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.ui.contribution;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ui.contribution.ModelConverterDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelConverterManager<D extends ModelConverterDescriptor> {
    protected List<D> descriptors;

    public void dispose() {
        if (this.descriptors != null) {
            this.descriptors.clear();
            this.descriptors = null;
        }
    }

    protected abstract ModelConverterDescriptorWizardNode createModelConverterDescriptorWizardNode(D var1);

    public Map<D, ModelConverterDescriptorWizardNode> createModelConverterDescriptorWizardNodeMap() {
        if (this.descriptors != null) {
            HashMap<ModelConverterDescriptor, ModelConverterDescriptorWizardNode> map = new HashMap<ModelConverterDescriptor, ModelConverterDescriptorWizardNode>();
            for (ModelConverterDescriptor descriptor : this.descriptors) {
                ModelConverterDescriptorWizardNode wizardNode = this.createModelConverterDescriptorWizardNode(descriptor);
                map.put(descriptor, wizardNode);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public List<D> getModelConverterDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.retrieveContributedModelConverterDescriptors();
        }
        return this.descriptors;
    }

    public D getModelConverterDescriptor(String id) {
        if (id != null) {
            for (ModelConverterDescriptor descriptor : this.getModelConverterDescriptors()) {
                if (!id.equals(descriptor.getID())) continue;
                return (D)descriptor;
            }
        }
        return null;
    }

    protected abstract String getPluginId();

    protected abstract String getExtensionPointId();

    public List<D> retrieveContributedModelConverterDescriptors() {
        ArrayList<D> descriptors = new ArrayList<D>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPluginId(), this.getExtensionPointId());
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            D descriptor = this.createFromContribution(configurationElements[i]);
            if (descriptor != null) {
                descriptors.add(descriptor);
            }
            ++i;
        }
        return descriptors;
    }

    protected abstract String getElementName();

    protected abstract ModelConverterDescriptorImpl createModelConverterDescriptorImpl();

    protected D createFromContribution(IConfigurationElement configurationElement) {
        if (this.getElementName().equals(configurationElement.getName())) {
            String id = configurationElement.getAttribute("id");
            String name = configurationElement.getAttribute("name");
            String wizard = configurationElement.getAttribute("wizard");
            if (id != null && name != null && wizard != null) {
                ModelConverterDescriptorImpl descriptorImpl = this.createModelConverterDescriptorImpl();
                descriptorImpl.setID(id);
                descriptorImpl.setName(name);
                descriptorImpl.setDescription(configurationElement.getAttribute("description"));
                descriptorImpl.configurationElement = configurationElement;
                String iconValue = configurationElement.getAttribute("icon");
                if (iconValue != null) {
                    URI iconURI = URI.createURI((String)iconValue);
                    if (iconURI.isRelative()) {
                        URI pluginURI = URI.createPlatformPluginURI((String)(String.valueOf(configurationElement.getContributor().getName()) + "/"), (boolean)true);
                        iconURI = iconURI.resolve(pluginURI);
                    }
                    try {
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(iconURI.toString()));
                        descriptorImpl.setIcon(imageDescriptor.createImage());
                    }
                    catch (Exception exception) {}
                }
                ModelConverterDescriptorImpl descriptor = descriptorImpl;
                return (D)descriptor;
            }
        }
        return null;
    }

    public static class ModelConverterDescriptorImpl
    implements ModelConverterDescriptor {
        protected String id;
        protected String name;
        protected Image icon;
        protected String description;
        protected IConfigurationElement configurationElement;

        public String getID() {
            return this.id;
        }

        public void setID(String id) {
            this.id = id;
        }

        public Image getIcon() {
            return this.icon;
        }

        public void setIcon(Image icon) {
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        protected Object createExecutableExtension(String attribute) {
            if (this.configurationElement != null) {
                try {
                    return this.configurationElement.createExecutableExtension(attribute);
                }
                catch (Exception exception) {}
            }
            return null;
        }
    }

    public static class ModelConverterDescriptorLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ModelConverterDescriptor) {
                return ((ModelConverterDescriptor)element).getIcon();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ModelConverterDescriptor) {
                return ((ModelConverterDescriptor)element).getName();
            }
            return super.getText(element);
        }
    }

    public static abstract class ModelConverterDescriptorWizardNode
    implements IWizardNode {
        protected boolean contentCreated = false;
        protected ModelConverterDescriptor descriptor;
        protected IWizard wizard;
        protected Point point;

        public ModelConverterDescriptorWizardNode(ModelConverterDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public void dispose() {
            this.wizard = null;
            this.descriptor = null;
            this.point = null;
        }

        public IWizard getWizard() {
            if (this.wizard == null && this.descriptor != null) {
                this.wizard = this.createWizard();
            }
            return this.wizard;
        }

        protected abstract IWizard createWizard();

        public boolean isContentCreated() {
            return this.contentCreated;
        }

        public void setContentCreated(boolean contentCreated) {
            this.contentCreated = contentCreated;
        }

        public Point getExtent() {
            if (this.point == null) {
                this.point = new Point(-1, -1);
            }
            return this.point;
        }
    }
}

