/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.property;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierCacheHandler;
import org.eclipse.emf.teneo.hibernate.resource.HibernateResource;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;

public class EReferencePropertyHandler
implements Getter,
Setter,
PropertyAccessor,
ExtensionPoint {
    private static final long serialVersionUID = -3712366809398761331L;
    private static Log log = LogFactory.getLog(EReferencePropertyHandler.class);
    protected EReference eReference;
    protected boolean isBidirectional;
    private int featureId = -1;
    private boolean isId = false;

    public void initialize(EReference eReference) {
        this.eReference = eReference;
        EClass eClass = eReference.getEContainingClass();
        this.featureId = eClass.getFeatureID((EStructuralFeature)eReference);
        boolean bl = this.isBidirectional = eReference.getEOpposite() != null && !eReference.getEOpposite().isTransient();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created getter/setter for " + StoreUtil.toString((EStructuralFeature)eReference)));
        }
    }

    public EReference getEReference() {
        return this.eReference;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Member getMember() {
        return null;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Object get(Object owner) throws HibernateException {
        Object result = ((EObject)owner).eGet((EStructuralFeature)this.eReference, false);
        if (result instanceof HibernateProxy) {
            return result;
        }
        return ((EObject)owner).eGet((EStructuralFeature)this.eReference, true);
    }

    public Object getForInsert(Object owner, Map mergeMap, SessionImplementor session) throws HibernateException {
        return this.get(owner);
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        EObject eobj;
        Object curValue = this.get(target);
        if (this.isId()) {
            IdentifierCacheHandler.getInstance().setID(target, value);
        }
        if (this.isBidirectional || target instanceof DynamicEObjectImpl && this.eReference.isContainment()) {
            if (curValue != value) {
                NotificationChain nots;
                if (value == null) {
                    nots = ((InternalEObject)target).eInverseRemove((InternalEObject)curValue, this.featureId, this.eReference.getEType().getInstanceClass(), null);
                    if (nots != null) {
                        nots.dispatch();
                    }
                } else {
                    nots = ((InternalEObject)target).eInverseAdd((InternalEObject)value, this.featureId, this.eReference.getEType().getInstanceClass(), null);
                    if (nots != null) {
                        nots.dispatch();
                    }
                }
            }
        } else {
            if (curValue == value) {
                return;
            }
            eobj = (EObject)target;
            eobj.eSet((EStructuralFeature)this.eReference, value);
        }
        eobj = (EObject)target;
        Resource res = eobj.eResource();
        if (value != null && res instanceof HibernateResource && ((EObject)value).eResource() == null) {
            boolean loading = ((HibernateResource)res).isLoading();
            try {
                ((HibernateResource)res).setIsLoading(true);
                ((HibernateResource)res).addToContentOrAttach((InternalEObject)value, this.eReference);
            }
            finally {
                ((HibernateResource)res).setIsLoading(loading);
            }
        }
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return InternalEObject.class;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setId(boolean isId) {
        this.isId = isId;
    }
}

