/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVDelegatingList;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVValueHolder;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.util.SessionFactoryHelper;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyCollectionUtils {
    public static final int DEFAULT_PAGE_SIZE = 100;

    public static <E> Iterator<E> getPagedLoadingIterator(Collection<E> coll, int pageSize) {
        if (!LazyCollectionUtils.isLazyLoadableCollection(coll)) {
            return coll.iterator();
        }
        PersistableDelegateList persistableList = (PersistableDelegateList)coll;
        AbstractPersistentCollection persistentCollection = (AbstractPersistentCollection)persistableList.getDelegate();
        SessionImplementor session = persistentCollection.getSession();
        PagingIterator pagingIterator = new PagingIterator();
        pagingIterator.setCollection(persistentCollection);
        pagingIterator.setPageSize(pageSize);
        pagingIterator.setSession((Session)session);
        CollectionEntry entry = session.getPersistenceContext().getCollectionEntry((PersistentCollection)persistentCollection);
        AbstractCollectionPersister persister = (AbstractCollectionPersister)entry.getLoadedPersister();
        pagingIterator.setEavCollection(coll instanceof EAVDelegatingList);
        pagingIterator.setIndexColumnNames(persister.getIndexColumnNames());
        return pagingIterator;
    }

    public static int size(Collection<?> coll) {
        if (!LazyCollectionUtils.isLazyLoadableCollection(coll)) {
            return coll.size();
        }
        PersistableDelegateList persistableList = (PersistableDelegateList)coll;
        AbstractPersistentCollection persistentCollection = (AbstractPersistentCollection)persistableList.getDelegate();
        SessionImplementor session = persistentCollection.getSession();
        QueryableCollection persister = new SessionFactoryHelper(session.getFactory()).getCollectionPersister(persistentCollection.getRole());
        return persister.getSize(persistentCollection.getKey(), session);
    }

    public static <E> boolean isLazyLoadableCollection(Collection<E> coll) {
        boolean lazyLoadable = coll instanceof PersistableDelegateList;
        if (!lazyLoadable) {
            return false;
        }
        PersistableDelegateList persistableList = (PersistableDelegateList)coll;
        if (!(lazyLoadable &= persistableList.getDelegate() instanceof AbstractPersistentCollection)) {
            return false;
        }
        AbstractPersistentCollection persistentCollection = (AbstractPersistentCollection)persistableList.getDelegate();
        SessionImplementor session = persistentCollection.getSession();
        return session != null && session.isOpen() && session.getPersistenceContext().containsCollection((PersistentCollection)persistentCollection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PagingIterator<E>
    implements Iterator<E> {
        private Session session;
        private int pageSize;
        private Boolean hasNext = null;
        private int currentIteratorIndex = 0;
        private int nextPageStart = 0;
        private List<E> content;
        private Object collection;
        private String[] indexColumnNames;
        private String orderBy = "";
        private boolean eavCollection;

        @Override
        public boolean hasNext() {
            if (this.content == null) {
                this.setPageInformation();
            }
            if (this.currentIteratorIndex < this.content.size()) {
                return true;
            }
            if (this.hasNext != null) {
                return this.hasNext;
            }
            if (this.content.size() < this.pageSize) {
                this.hasNext = false;
                return this.hasNext;
            }
            this.hasNext = !this.loadNextPage().isEmpty();
            return this.hasNext;
        }

        @Override
        public E next() {
            if (this.currentIteratorIndex < this.content.size()) {
                return this.convert(this.content.get(this.currentIteratorIndex++));
            }
            this.setPageInformation();
            if (this.content.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.convert(this.content.get(this.currentIteratorIndex++));
        }

        private E convert(E value) {
            if (value instanceof EAVValueHolder) {
                return (E)((EAVValueHolder)value).getValue();
            }
            return value;
        }

        private void setPageInformation() {
            this.content = this.loadNextPage();
            this.currentIteratorIndex = 0;
            this.hasNext = null;
            this.nextPageStart += this.content.size();
        }

        private List<E> loadNextPage() {
            Query query = this.isEavCollection() ? this.session.createFilter(this.collection, " order by this.listIndex ") : this.session.createFilter(this.collection, this.orderBy);
            query.setMaxResults(this.pageSize);
            query.setFirstResult(this.nextPageStart);
            return query.list();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal is not supported by the paging iterator");
        }

        public Session getSession() {
            return this.session;
        }

        public void setSession(Session session) {
            this.session = session;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public Object getCollection() {
            return this.collection;
        }

        public void setCollection(Object collection) {
            this.collection = collection;
        }

        public String[] getIndexColumnNames() {
            return this.indexColumnNames;
        }

        public void setIndexColumnNames(String[] indexColumnNames) {
            this.indexColumnNames = indexColumnNames;
            StringBuilder sb = new StringBuilder();
            if (indexColumnNames != null) {
                String[] stringArray = indexColumnNames;
                int n = indexColumnNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String indexColumnName = stringArray[n2];
                    if (sb.length() == 0) {
                        sb.append(" order by ");
                    } else {
                        sb.append(", ");
                    }
                    sb.append(indexColumnName.replaceAll("`", "").replaceAll("\"", ""));
                    ++n2;
                }
            }
            this.orderBy = sb.toString();
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public boolean isEavCollection() {
            return this.eavCollection;
        }

        public void setEavCollection(boolean eavCollection) {
            this.eavCollection = eavCollection;
        }
    }
}

