/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.tuplizer;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.mapping.SerializableDynamicEObjectImpl;
import org.eclipse.emf.teneo.type.PersistentStoreAdapter;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;

public class EMFInstantiator
implements Instantiator {
    private static final long serialVersionUID = 6946442685247491904L;
    private static Log log = LogFactory.getLog(EMFInstantiator.class);
    private final EClass eclass;
    private final Class<?> proxyInterface;
    private final Class<?> mappedClass;
    private boolean isDynamicEObject = false;

    public EMFInstantiator(EClass eclass, PersistentClass pc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating eobject instantiator for " + pc.getEntityName() + " and eclass " + eclass.getName()));
        }
        this.proxyInterface = pc.getProxyInterface();
        this.eclass = eclass;
        this.mappedClass = eclass.getInstanceClass();
    }

    public EMFInstantiator(EClass eclass, Component component) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating eobject instantiator for component eclass " + eclass.getName()));
        }
        this.eclass = eclass;
        this.mappedClass = eclass.getInstanceClass();
        this.proxyInterface = null;
    }

    public Object instantiate() {
        Object eobject;
        if (this.isDynamicEObject) {
            eobject = new SerializableDynamicEObjectImpl(this.eclass);
        } else {
            eobject = EcoreUtil.create((EClass)this.eclass);
            if (eobject instanceof DynamicEObjectImpl) {
                eobject = new SerializableDynamicEObjectImpl(this.eclass);
                this.isDynamicEObject = true;
            }
        }
        PersistentStoreAdapter adapter = StoreUtil.getPersistentStoreAdapter((EObject)eobject);
        adapter.setTargetCreatedByORM(true);
        if (eobject == null) {
            throw new HbMapperException("The mapped " + this.mappedClass.getName() + " class can not be instantiated." + " Possibly the class it is not an eclass or it is abstract.");
        }
        return eobject;
    }

    public Object instantiate(Serializable id) {
        return this.instantiate();
    }

    public boolean isInstance(Object object) {
        if (!(object instanceof EObject)) {
            return false;
        }
        EObject eobject = (EObject)object;
        if (eobject.eClass() == this.eclass) {
            return true;
        }
        if (this.isSuperTypeOf(this.eclass, eobject.eClass())) {
            return true;
        }
        return this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }

    private boolean isSuperTypeOf(EClass superEClass, EClass eclass) {
        for (EClass testSuperEClass : eclass.getESuperTypes()) {
            if (testSuperEClass == superEClass) {
                return true;
            }
            if (!this.isSuperTypeOf(superEClass, testSuperEClass)) continue;
            return true;
        }
        return false;
    }
}

