/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.OneToMany;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.Filter;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractAssociationMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class TypedEReferenceMapper
extends AbstractAssociationMapper
implements ExtensionPoint {
    public void process(PAnnotatedEReference paReference) {
        if (paReference.getModelEReference().isMany()) {
            this.processMany((PAnnotatedEStructuralFeature)paReference);
        } else {
            this.processSingle((PAnnotatedEStructuralFeature)paReference);
        }
    }

    private void processSingle(PAnnotatedEStructuralFeature paEFeature) {
        String name = this.getHbmContext().getPropertyName(paEFeature.getModelEStructuralFeature());
        Element propElement = this.getHbmContext().getCurrent().addElement("property").addAttribute("name", name);
        this.addColumnsAndFormula(propElement, paEFeature, this.getColumns(paEFeature), true, true);
        this.setType(paEFeature, propElement);
        this.addAccessor(propElement);
    }

    private void processMany(PAnnotatedEStructuralFeature paEFeature) {
        HbAnnotatedEReference hbReference = (HbAnnotatedEReference)paEFeature;
        Element collElement = this.addCollectionElement(paEFeature);
        Element keyElement = collElement.addElement("key");
        JoinTable jt = paEFeature.getJoinTable();
        ArrayList<JoinColumn> jcs = paEFeature.getJoinColumns() == null ? new ArrayList<JoinColumn>() : paEFeature.getJoinColumns();
        OneToMany otm = paEFeature.getOneToMany();
        if (jt != null) {
            this.addJoinTable(hbReference, collElement, keyElement, jt);
            this.addKeyColumns(hbReference, keyElement, jcs);
        } else {
            this.addKeyColumns(hbReference, keyElement, jcs);
        }
        if (otm.isIndexed() && hbReference.getHbIdBag() == null) {
            this.addListIndex(collElement, paEFeature);
        }
        this.addFetchType(collElement, otm.getFetch());
        this.addCascadesForMany(collElement, this.getCascades(hbReference.getHbCascade(), (List<CascadeType>)otm.getCascade(), otm.isOrphanRemoval()));
        this.addElementElement(collElement, paEFeature, this.getColumns(paEFeature), otm.getTargetEntity());
        this.addAccessor(collElement);
        this.mapFilter(collElement, (List<Filter>)((HbAnnotatedETypeElement)paEFeature).getFilter());
    }
}

