/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.ui.launching.LaunchingUtils;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConstants;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.launching.AbstractMainTab;
import org.eclipse.qvtd.debug.ui.launching.ParameterRow;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class MainTab
extends AbstractMainTab
implements QVTiLaunchConstants {
    protected Text txPath;
    protected Button txBrowseWS;
    protected Button txBrowseFile;
    protected Group inputsGroup;
    protected Group outputsGroup;
    private Composite directionGroup;
    protected Combo modeCombo;
    protected Combo directionCombo;
    protected Button partialCheckButton;
    private Group intermediatesGroup;
    protected boolean initializing = false;
    private boolean updating = false;
    private boolean txModified = false;
    private Transformation transformation = null;
    private boolean directionModified = false;
    private boolean groupsModified = false;

    protected void addListeners() {
        this.txPath.addModifyListener((ModifyListener)new TransformationModifyListener());
    }

    public boolean canSave() {
        String path;
        String name;
        ParameterRow row;
        int i;
        Control[] children;
        String txName;
        URI txURI;
        assert (!this.initializing);
        ResourceSet resourceSet = this.getEnvironmentFactory().getResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        boolean txExists = uriConverter.exists(txURI = URI.createURI((String)(txName = this.txPath.getText().trim()), (boolean)true), null);
        if (!txExists) {
            this.setErrorMessage("Transformation '" + txName + "' does not exist");
            return false;
        }
        if (this.inputsGroup != null) {
            children = this.inputsGroup.getChildren();
            i = 0;
            while (i < children.length) {
                row = (ParameterRow)children[i];
                name = row.name.getText();
                path = row.path.getText();
                URI inURI = URI.createURI((String)path, (boolean)true);
                boolean inExists = uriConverter.exists(inURI, null);
                if (!inExists) {
                    this.setErrorMessage("Input '" + name + "': '" + path + "' does not exist");
                    return false;
                }
                ++i;
            }
        }
        if (this.outputsGroup != null) {
            children = this.outputsGroup.getChildren();
            i = 0;
            while (i < children.length) {
                row = (ParameterRow)children[i];
                name = row.name.getText();
                path = row.path.getText();
                URI outURI = URI.createURI((String)path, (boolean)true);
                boolean outExists = uriConverter.exists(outURI.trimSegments(1), null);
                if (!outExists) {
                    this.setErrorMessage("Output '" + name + "': '" + path + "' uses non-existent parent folder");
                    return false;
                }
                ++i;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public void createControl(Composite parent) {
        Composite control = this.createForm(parent);
        this.addListeners();
        LaunchingUtils.prepareBrowseWorkspaceButton((Button)this.txBrowseWS, (Text)this.txPath, (boolean)false);
        LaunchingUtils.prepareBrowseFileSystemButton((Button)this.txBrowseFile, (Text)this.txPath, (boolean)false);
        this.updateParametersGroup(this.inputsGroup, 0, EMPTY_MAP);
        this.updateParametersGroup(this.outputsGroup, 8192, EMPTY_MAP);
        control.setBounds(0, 0, 300, 300);
        control.layout();
        control.pack();
    }

    protected void createDirectionGroup(Group txGroup) {
        this.directionGroup = new Composite((Composite)txGroup, 0);
        GridLayout gl_directionGroup = new GridLayout(5, false);
        gl_directionGroup.marginWidth = 0;
        gl_directionGroup.marginHeight = 0;
        this.directionGroup.setLayout((Layout)gl_directionGroup);
        this.directionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label modeLabel = new Label(this.directionGroup, 0);
        modeLabel.setSize(31, 15);
        modeLabel.setText("Mode");
        this.modeCombo = new Combo(this.directionGroup, 0);
        this.modeCombo.setToolTipText("Whether the execution\n- checks that the output corresponds to the input\n- creates new output model elements\n- updates existing model elements where possible ");
        this.modeCombo.setItems(new String[]{"CHECK", "ENFORCE - CREATE", "ENFORCE - UPDATE"});
        this.modeCombo.select(0);
        Label directionLabel = new Label(this.directionGroup, 0);
        directionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        directionLabel.setText("Direction");
        this.directionCombo = new Combo(this.directionGroup, 0);
        this.directionCombo.setToolTipText("The enforceable output domain defining the direction of a multi-directional trnsformation");
        this.directionCombo.setItems(new String[]{"NONE"});
        this.directionCombo.select(0);
        this.partialCheckButton = new Button(this.directionGroup, 32);
        this.partialCheckButton.setToolTipText("Whether the input may be part of a larger model, or must be the whole model.");
        this.partialCheckButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.partialCheckButton.setText("Partial Model");
    }

    public Composite createForm(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group txGroup = new Group(control, 0);
        txGroup.setToolTipText("The transformation selection and its directional configuration ");
        txGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        txGroup.setText("Transformation");
        txGroup.setLayout((Layout)new GridLayout(3, false));
        this.txPath = new Text((Composite)txGroup, 2048);
        this.txPath.setToolTipText("The transformation to execute");
        GridData gd_txPath = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txPath.minimumWidth = 100;
        this.txPath.setLayoutData((Object)gd_txPath);
        this.txBrowseWS = new Button((Composite)txGroup, 0);
        this.txBrowseWS.setText("Browse Workspace...");
        this.txBrowseFile = new Button((Composite)txGroup, 0);
        this.txBrowseFile.setText("Browse File...");
        this.createDirectionGroup(txGroup);
        this.inputsGroup = new Group(control, 0);
        this.inputsGroup.setToolTipText("The models bound to each input domain");
        this.inputsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.inputsGroup.setText("Inputs");
        this.inputsGroup.setLayout((Layout)new GridLayout(1, false));
        this.outputsGroup = new Group(control, 0);
        this.outputsGroup.setToolTipText("The models bound to each output domain");
        this.outputsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.outputsGroup.setText("Outputs");
        this.outputsGroup.setLayout((Layout)new GridLayout(1, false));
        this.intermediatesGroup = new Group(control, 0);
        this.intermediatesGroup.setToolTipText("The intermediate models nd files");
        this.intermediatesGroup.setLayout((Layout)new GridLayout(1, false));
        this.intermediatesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.intermediatesGroup.setText("Intermediates");
        return control;
    }

    protected String getDefaultPath(@NonNull Group group, String name) {
        if (name != null) {
            Control[] controlArray = group.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof ParameterRow) {
                    ParameterRow row = (ParameterRow)child;
                    if (name.equals(row.name.getText())) {
                        return row.path.getText();
                    }
                }
                ++n2;
            }
        }
        return "";
    }

    @NonNull
    protected QVTiEnvironmentFactory getEnvironmentFactory() {
        OCLInternal ocl2 = this.ocl;
        if (ocl2 == null) {
            this.ocl = ocl2 = OCLInternal.newInstance((EnvironmentFactoryInternal)new QVTiEnvironmentFactory(BasicProjectManager.createDefaultProjectManager(), null));
        }
        return (QVTiEnvironmentFactory)ocl2.getEnvironmentFactory();
    }

    public Image getImage() {
        return QVTdDebugUIPlugin.getDefault().createImage("icons/QVTiModelFile.gif");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        assert (!this.initializing);
        try {
            try {
                this.initializing = true;
                if (configuration != null) {
                    this.initializeInternal(configuration);
                }
            }
            catch (CoreException coreException) {
                this.initializing = false;
                this.txModified = true;
                this.updateLaunchConfigurationDialog();
            }
        }
        finally {
            this.initializing = false;
            this.txModified = true;
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void initializeInternal(@NonNull ILaunchConfiguration configuration) throws CoreException {
        this.txPath.setText(configuration.getAttribute("tx", ""));
        Map inMap = configuration.getAttribute("in", EMPTY_MAP);
        Map outMap = configuration.getAttribute("out", EMPTY_MAP);
        if (inMap != null) {
            this.updateParametersGroup((Group)ClassUtil.nonNullState((Object)this.inputsGroup), 0, inMap);
        }
        if (outMap != null) {
            this.updateParametersGroup((Group)ClassUtil.nonNullState((Object)this.outputsGroup), 8192, outMap);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("tx", this.txPath.getText());
        HashMap<String, String> inputMap = new HashMap<String, String>();
        Control[] controlArray = this.inputsGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ParameterRow) {
                ParameterRow row = (ParameterRow)child;
                inputMap.put(row.name.getText(), row.path.getText());
            }
            ++n2;
        }
        configuration.setAttribute("in", inputMap);
        HashMap<String, String> outputMap = new HashMap<String, String>();
        Control[] controlArray2 = this.outputsGroup.getChildren();
        int n3 = controlArray2.length;
        n = 0;
        while (n < n3) {
            Control child = controlArray2[n];
            if (child instanceof ParameterRow) {
                ParameterRow row = (ParameterRow)child;
                outputMap.put(row.name.getText(), row.path.getText());
            }
            ++n;
        }
        configuration.setAttribute("out", outputMap);
    }

    protected void refreshParametersGroup(@NonNull Group group, int style, @NonNull Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        Control[] children = group.getChildren();
        int i = 0;
        while (i < children.length) {
            ParameterRow row = (ParameterRow)children[i];
            String text = row.name.getText();
            String path = map.get(text);
            if (path != null) {
                row.path.setText(path);
            }
            ++i;
        }
        group.layout();
    }

    @Override
    protected void setDefaults(@NonNull ILaunchConfigurationWorkingCopy configuration, @NonNull IFile iFile) {
        configuration.setAttribute("tx", iFile.getFullPath().toString());
        configuration.setAttribute("in", EMPTY_MAP);
        configuration.setAttribute("out", EMPTY_MAP);
    }

    public void updateLaunchConfigurationDialog() {
        if (!this.initializing && !this.updating) {
            this.updating = true;
            try {
                Transformation transformation2;
                if (this.txModified) {
                    if (this.txPath.isDisposed()) {
                        return;
                    }
                    String txName = this.txPath.getText().trim();
                    URI txURI = URI.createURI((String)txName, (boolean)true);
                    try {
                        this.transformation = this.updateTransformation(txURI);
                        this.directionModified = true;
                    }
                    catch (Throwable ex) {
                        this.setErrorMessage("Failed to load '" + txName + "': " + ex.toString());
                        super.updateLaunchConfigurationDialog();
                        this.updating = false;
                        return;
                    }
                    this.txModified = false;
                }
                if ((transformation2 = this.transformation) == null) {
                    return;
                }
                if (this.directionModified) {
                    this.updateDirection(transformation2);
                    this.directionModified = false;
                    this.groupsModified = true;
                }
                if (this.groupsModified) {
                    if (this.txPath.isDisposed()) {
                        return;
                    }
                    HashMap<String, String> inputMap = new HashMap<String, String>();
                    HashMap<String, String> outputMap = new HashMap<String, String>();
                    this.updateGroups(transformation2, inputMap, outputMap);
                    Group inputsGroup2 = this.inputsGroup;
                    Group outputsGroup2 = this.outputsGroup;
                    for (String inputName : inputMap.keySet()) {
                        inputMap.put(inputName, this.getDefaultPath(inputsGroup2, inputName));
                    }
                    for (String outputName : outputMap.keySet()) {
                        outputMap.put(outputName, this.getDefaultPath(outputsGroup2, outputName));
                    }
                    this.updateParametersGroup(inputsGroup2, 0, inputMap);
                    this.updateParametersGroup(outputsGroup2, 8192, outputMap);
                    this.groupsModified = false;
                }
            }
            finally {
                super.updateLaunchConfigurationDialog();
                this.updating = false;
            }
        }
    }

    protected abstract void updateDirection(@NonNull Transformation var1);

    protected abstract void updateGroups(@NonNull Transformation var1, @NonNull Map<String, String> var2, @NonNull Map<String, String> var3);

    protected void updateParametersGroup(@NonNull Group group, int style, @NonNull Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        Control[] children = group.getChildren();
        int iMax = Math.min(children.length, keys.size());
        int i = 0;
        while (i < iMax) {
            ParameterRow row = (ParameterRow)children[i];
            String string = (String)keys.get(i);
            row.name.setText(string);
            row.path.setText(map.get(string));
            ++i;
        }
        while (i < keys.size()) {
            String string = (String)keys.get(i);
            String parameterPath = map.get(string);
            new ParameterRow(this, group, style, string, parameterPath);
            ++i;
        }
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        group.layout();
    }

    @NonNull
    protected abstract Transformation updateTransformation(@NonNull URI var1) throws IOException;

    protected class DirectionModifyListener
    implements ModifyListener {
        protected DirectionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!MainTab.this.directionModified) {
                MainTab.this.directionModified = true;
                MainTab.this.updateLaunchConfigurationDialog();
            }
        }
    }

    protected class TransformationModifyListener
    implements ModifyListener {
        protected TransformationModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!MainTab.this.txModified) {
                MainTab.this.txModified = true;
                MainTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

