/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.tck.LRAClientOps;
import org.eclipse.microprofile.lra.tck.participant.api.ResourceParent;
import org.eclipse.microprofile.lra.tck.participant.api.WrongHeaderException;

@ApplicationScoped
@Path(value="non-participating-tck-resource")
@LRA(value=LRA.Type.SUPPORTS, end=false)
public class NonParticipatingTckResource
extends ResourceParent {
    public static final String TCK_NON_PARTICIPANT_RESOURCE_PATH = "non-participating-tck-resource";
    public static final String START_AND_END_PATH = "/start-and-end";
    public static final String START_BUT_DONT_END_PATH = "/start-dont-end";
    public static final String START_AND_END_NESTED_PATH = "/start-nested-and-end";
    public static final String START_BUT_DONT_END_NESTED_PATH = "/start-nested-and-dont-end";
    public static final String NEVER_PATH = "/never";
    public static final String END_PATH = "/end";
    public static final String SUPPORTS_PATH = "/supports";
    public static final String STATUS_CODE_QUERY_NAME = "Coerce-Status";
    public static final String START_LRA_VIA_REMOTE_INVOCATION = "/start-via-remote-invocation";
    @Context
    private UriInfo context;

    @PUT
    @Path(value="/never")
    @LRA(value=LRA.Type.NEVER)
    public Response neverRunWithLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/supports")
    @LRA(value=LRA.Type.SUPPORTS, end=false)
    public Response supports(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/start-and-end")
    @LRA(value=LRA.Type.REQUIRES_NEW, cancelOnFamily={Response.Status.Family.SERVER_ERROR})
    public Response startAndEndLRA(@HeaderParam(value="Long-Running-Action") URI lraId, @DefaultValue(value="200") @QueryParam(value="Coerce-Status") int coerceStatus) {
        return Response.status((int)coerceStatus).entity((Object)this.checkLRANotNull(lraId)).build();
    }

    @PUT
    @Path(value="/start-dont-end")
    @LRA(value=LRA.Type.REQUIRES_NEW, end=false, cancelOnFamily={Response.Status.Family.SERVER_ERROR})
    public Response startDontEndLRA(@HeaderParam(value="Long-Running-Action") URI lraId, @DefaultValue(value="200") @QueryParam(value="Coerce-Status") int coerceStatus) {
        return Response.status((int)coerceStatus).entity((Object)this.checkLRANotNull(lraId)).build();
    }

    @PUT
    @Path(value="/end")
    @LRA(value=LRA.Type.MANDATORY, cancelOnFamily={Response.Status.Family.SERVER_ERROR})
    public Response endLRA(@HeaderParam(value="Long-Running-Action") URI lraId, @DefaultValue(value="200") @QueryParam(value="Coerce-Status") int coerceStatus) {
        return Response.status((int)coerceStatus).entity((Object)this.checkLRANotNull(lraId)).build();
    }

    @PUT
    @Path(value="/start-nested-and-end")
    @LRA(value=LRA.Type.NESTED, cancelOnFamily={Response.Status.Family.SERVER_ERROR})
    public Response startAndEndNestedLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/start-nested-and-dont-end")
    @LRA(value=LRA.Type.NESTED, end=false, cancelOnFamily={Response.Status.Family.SERVER_ERROR})
    public Response startAndDontEndNestedLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/start-via-remote-invocation")
    @LRA(value=LRA.Type.SUPPORTS, end=false, cancelOnFamily={Response.Status.Family.SERVER_ERROR})
    public Response notSupportedButCallServiceWhichStartsButDoesntEndAnLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)this.invokeRestEndpoint(lraId, TCK_NON_PARTICIPANT_RESOURCE_PATH, START_BUT_DONT_END_PATH, 200)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeRestEndpoint(URI lra, String basePath, String path, int coerceResponse) {
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.context.getBaseUri());
            String string = new LRAClientOps(target).invokeRestEndpointAndReturnLRA(lra, basePath, path, coerceResponse);
            return string;
        }
    }

    private URI checkLRANotNull(URI lraId) {
        if (lraId == null) {
            throw new WrongHeaderException(String.format("%s: missing '%s' header", this.context.getPath(), "Long-Running-Action"));
        }
        return lraId;
    }
}

