/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.message;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.junit.jupiter.api.Test;

public class ShowMessageTest
extends AbstractTestWithProject {
    @Test
    public void testShowMessage() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "");
        IDE.openEditor((IWorkbenchPage)UI.getActivePage(), (IFile)file);
        String messageContent = "test notification " + System.currentTimeMillis();
        MessageParams message = new MessageParams(MessageType.Error, messageContent);
        Display display = Display.getDefault();
        Set currentShells = Stream.of(display.getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        List remoteProxies = MockLanguageServer.INSTANCE.getRemoteProxies();
        remoteProxies.forEach(client -> client.showMessage(message));
        TestUtils.waitForAndAssertCondition(3000, () -> Stream.of(display.getShells()).filter(Shell::isVisible).count() > (long)currentShells.size());
    }
}

