/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.folding;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FoldingTest
extends AbstractTest {
    private static final int MAX_WAIT_FOR_FOLDING = 3000;
    private static final String CONTENT = "/**\n * SPDX-License-Identifier: EPL-2.0\n */\nimport\nimport\nimport\n/**\n * Some comment\n */\nvisible\n";

    @Test
    public void testLicenseHeaderAutoFolding() throws CoreException {
        this.configureCollapse("foldingReconcilingStrategy.collapseLicenseHeaders", true);
        this.configureCollapse("foldingReconcilingStrategy.collapseImports", false);
        IEditorPart editor = this.createEditor();
        TestUtils.waitForAndAssertCondition(3000, () -> Assertions.assertEquals((Object)"/**\nimport\nimport\nimport\n/**\n * Some comment\n */\nvisible", (Object)((StyledText)editor.getAdapter(Control.class)).getText().trim()));
    }

    @Test
    public void testImportsAutoFolding() throws CoreException {
        this.configureCollapse("foldingReconcilingStrategy.collapseLicenseHeaders", false);
        this.configureCollapse("foldingReconcilingStrategy.collapseImports", true);
        IEditorPart editor = this.createEditor();
        TestUtils.waitForAndAssertCondition(3000, () -> Assertions.assertEquals((Object)"/**\n * SPDX-License-Identifier: EPL-2.0\n */\nimport\n/**\n * Some comment\n */\nvisible", (Object)((StyledText)editor.getAdapter(Control.class)).getText().trim()));
    }

    @Test
    public void testAutoFoldingDisabled() throws CoreException {
        this.configureCollapse("foldingReconcilingStrategy.collapseLicenseHeaders", false);
        this.configureCollapse("foldingReconcilingStrategy.collapseImports", false);
        IEditorPart editor = this.createEditor();
        DisplayHelper.sleep((long)3000L);
        Assertions.assertEquals((Object)CONTENT, (Object)((StyledText)editor.getAdapter(Control.class)).getText());
    }

    private IEditorPart createEditor() throws CoreException {
        FoldingRange foldingRangeLicense = new FoldingRange(0, 2);
        foldingRangeLicense.setKind("comment");
        FoldingRange foldingRangeImport = new FoldingRange(3, 5);
        foldingRangeImport.setKind("imports");
        MockLanguageServer.INSTANCE.setFoldingRanges(List.of(foldingRangeLicense, foldingRangeImport));
        return TestUtils.openEditor(TestUtils.createUniqueTestFile(null, CONTENT));
    }

    private void configureCollapse(String type, boolean collapse) {
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        store.setValue(type, collapse);
        store.setValue("foldingReconcilingStrategy.collapseImports", collapse);
    }
}

