/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.presentation;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.DSPStackFrame;
import org.eclipse.lsp4e.debug.debugmodel.DSPValue;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;

public class DAPWatchExpression
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        IDebugTarget iDebugTarget = context.getDebugTarget();
        if (iDebugTarget instanceof DSPDebugTarget) {
            DSPDebugTarget dapDebugger = (DSPDebugTarget)iDebugTarget;
            EvaluateArguments args = new EvaluateArguments();
            args.setExpression(expression);
            DSPStackFrame frame = (DSPStackFrame)((Object)NullSafetyHelper.castNonNull((Object)((Object)((DSPStackFrame)((Object)Adapters.adapt((Object)context, DSPStackFrame.class))))));
            args.setFrameId(frame.getFrameId());
            dapDebugger.getDebugProtocolServer().evaluate(args).thenAccept(res -> listener.watchEvaluationFinished(this.createWatchResult(dapDebugger, expression, (EvaluateResponse)res)));
        }
    }

    private IWatchExpressionResult createWatchResult(final DSPDebugTarget dapDebugger, final String expression, final EvaluateResponse res) {
        return new IWatchExpressionResult(){

            public boolean hasErrors() {
                return false;
            }

            public @Nullable IValue getValue() {
                return new DSPValue(dapDebugger, (Integer)res.getVariablesReference(), res.getResult());
            }

            public String getExpressionText() {
                return expression;
            }

            public @Nullable DebugException getException() {
                return null;
            }

            public String[] getErrorMessages() {
                return ArrayUtil.NO_STRINGS;
            }
        };
    }
}

