/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.lca;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.LowestCommonAncestorAlgorithm;

public class NaiveLCAFinder<V, E>
implements LowestCommonAncestorAlgorithm<V> {
    private Graph<V, E> graph;

    public NaiveLCAFinder(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null");
    }

    @Override
    public V getLCA(V a, V b) {
        this.checkNodes(a, b);
        Set<V> lcaSet = this.getLCASet(a, b);
        if (lcaSet.isEmpty()) {
            return null;
        }
        return lcaSet.iterator().next();
    }

    @Override
    public Set<V> getLCASet(V a, V b) {
        Set<V> intersection;
        this.checkNodes(a, b);
        List<Set<V>> visitedSets = this.doubleBfs(a, b);
        if (visitedSets.get(0).size() < visitedSets.get(1).size()) {
            visitedSets.get(0).retainAll((Collection)visitedSets.get(1));
            intersection = visitedSets.get(0);
        } else {
            visitedSets.get(1).retainAll((Collection)visitedSets.get(0));
            intersection = visitedSets.get(1);
        }
        LinkedHashSet<V> nonLeaves = new LinkedHashSet<V>();
        for (V node : intersection) {
            for (E edge : this.graph.incomingEdgesOf(node)) {
                V source;
                if (!this.graph.getEdgeTarget(edge).equals(node) || !intersection.contains(source = this.graph.getEdgeSource(edge))) continue;
                nonLeaves.add(source);
            }
        }
        intersection.removeAll(nonLeaves);
        return intersection;
    }

    private List<Set<V>> doubleBfs(V a, V b) {
        ArrayList<ArrayDeque> queues = new ArrayList<ArrayDeque>(Arrays.asList(new ArrayDeque(), new ArrayDeque()));
        ArrayList<Set<V>> visitedSets = new ArrayList<Set<V>>(Arrays.asList(new HashSet(), new HashSet()));
        ((Queue)queues.get(0)).add(a);
        ((Queue)queues.get(1)).add(b);
        ((Set)visitedSets.get(0)).add(a);
        ((Set)visitedSets.get(1)).add(b);
        int ind = 0;
        while (!((Queue)queues.get(0)).isEmpty() || !((Queue)queues.get(1)).isEmpty()) {
            if (!((Queue)queues.get(ind)).isEmpty()) {
                Object node = ((Queue)queues.get(ind)).poll();
                if (!((Set)visitedSets.get(0)).contains(node) || !((Set)visitedSets.get(1)).contains(node)) {
                    for (E edge : this.graph.incomingEdgesOf(node)) {
                        if (!this.graph.getEdgeTarget(edge).equals(node)) continue;
                        V source = this.graph.getEdgeSource(edge);
                        if (((Set)visitedSets.get(ind)).contains(source)) continue;
                        ((Queue)queues.get(ind)).add(source);
                        ((Set)visitedSets.get(ind)).add(source);
                    }
                }
            }
            ind ^= 1;
        }
        return visitedSets;
    }

    private void checkNodes(V a, V b) {
        if (!this.graph.containsVertex(a)) {
            throw new IllegalArgumentException("invalid vertex: " + a);
        }
        if (!this.graph.containsVertex(b)) {
            throw new IllegalArgumentException("invalid vertex: " + b);
        }
    }
}

