/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantConnection;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.BaseVMCommandHandler;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.Messages;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.VagrantService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.terminal.connector.ssh.launcher.SshLauncherDelegate;

public class SSHVMCommandHandler
extends BaseVMCommandHandler {
    private static final String JSCH_ID = "org.eclipse.jsch.core";
    private static final String KEY = "PRIVATEKEY";

    @Override
    void executeInJob(IVagrantVM vm, IProgressMonitor monitor) {
        if (vm.ip() == null || vm.port() == 0 || vm.user() == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.SSHVMCommandHandler_failed, (String)Messages.SSHVMCommandHandler_bad_credentials));
            return;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("ssh.keep_alive", 300);
        properties.put("ip.port", vm.port());
        properties.put("delegateId", "org.eclipse.tm.terminal.connector.ssh.launcher.ssh");
        properties.put("selection", null);
        properties.put("ssh.password", "");
        VagrantConnection conn = (VagrantConnection)VagrantService.getInstance();
        if (!vm.identityFile().isEmpty() && !conn.isTrackedKey(vm.identityFile())) {
            this.setupKeyPreferences(vm.identityFile());
        }
        properties.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.ssh.SshConnector");
        properties.put("ip.host", vm.ip());
        properties.put("ssh.user", vm.user());
        properties.put("encoding", null);
        properties.put("timeout", 0);
        SshLauncherDelegate delegate = new SshLauncherDelegate();
        delegate.execute(properties, null);
    }

    private void setupKeyPreferences(String identityFile) {
        String currentKeys = InstanceScope.INSTANCE.getNode(JSCH_ID).get(KEY, "");
        if (currentKeys.isEmpty()) {
            currentKeys = DefaultScope.INSTANCE.getNode(JSCH_ID).get(KEY, "");
        }
        InstanceScope.INSTANCE.getNode(JSCH_ID).put(KEY, currentKeys + "," + identityFile);
        VagrantService.getInstance().addToTrackedKeys(identityFile);
        JSchCorePlugin.getPlugin().setNeedToLoadKeys(true);
    }

    @Override
    String getJobName(List<IVagrantVM> selectedVMs) {
        return Messages.SSHVMCommandHandler_title;
    }

    @Override
    String getTaskName(IVagrantVM vm) {
        return NLS.bind((String)Messages.SSHVMCommandHandler_msg, (Object[])new String[]{vm.id(), vm.ip()});
    }
}

