/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class LSPRenameProcessor
extends RefactoringProcessor {
    private static final String ID = "org.eclipse.lsp4e.operations.rename";
    private final IDocument document;
    private final int offset;
    private @Nullable LanguageServerWrapper refactoringServer;
    private @Nullable String newName;
    private @Nullable WorkspaceEdit rename;
    private @Nullable Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior> prepareRenameResult;

    public LSPRenameProcessor(IDocument document, int offset) {
        this.document = document;
        this.offset = offset;
    }

    public Object @Nullable [] getElements() {
        return null;
    }

    public String getIdentifier() {
        return ID;
    }

    public String getProcessorName() {
        return Messages.rename_processor_name;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            PrepareRenameParams params = new PrepareRenameParams();
            params.setTextDocument(NullSafetyHelper.castNonNull(LSPEclipseUtils.toTextDocumentIdentifier(this.document)));
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
            List list = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(this.document).withFilter(LSPRenameProcessor::isPrepareRenameProvider)).collectAll((w, ls) -> ls.getTextDocumentService().prepareRename(params).thenApply(result -> new Pair<LanguageServerWrapper, Either3>((LanguageServerWrapper)w, (Either3)result))).get(1000L, TimeUnit.MILLISECONDS);
            Optional<Pair> tmp = list.stream().filter(Objects::nonNull).filter(t -> t.second() != null).findFirst();
            if (tmp.isEmpty()) {
                status.addFatalError(Messages.rename_invalidated);
            } else {
                tmp.ifPresent(p -> {
                    this.refactoringServer = (LanguageServerWrapper)p.first();
                    this.prepareRenameResult = (Either3)p.second();
                });
            }
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not prepare rename due to timeout after 1 seconds in `textDocument/prepareRename`. 'newName' will be used", e);
        }
        catch (Exception e) {
            status.addFatalError(this.getErrorMessage(e));
        }
        return status;
    }

    public String getPlaceholder() {
        @Nullable String placeholder = null;
        if (this.prepareRenameResult != null) {
            placeholder = (String)this.prepareRenameResult.map(range -> {
                try {
                    int startOffset = LSPEclipseUtils.toOffset(range.getStart(), this.document);
                    int endOffset = LSPEclipseUtils.toOffset(range.getEnd(), this.document);
                    return this.document.get(startOffset, endOffset - startOffset);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                    return null;
                }
            }, PrepareRenameResult::getPlaceholder, options -> null);
        }
        return placeholder != null && !placeholder.isBlank() ? placeholder : "newName";
    }

    public static boolean isPrepareRenameProvider(@Nullable ServerCapabilities serverCapabilities) {
        if (serverCapabilities == null) {
            return false;
        }
        Either renameProvider = serverCapabilities.getRenameProvider();
        if (renameProvider == null) {
            return false;
        }
        if (renameProvider.isRight()) {
            return ((RenameOptions)renameProvider.getRight()).getPrepareProvider();
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        String newName = this.newName;
        if (newName == null) {
            return status;
        }
        try {
            RenameParams params = new RenameParams();
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
            params.setTextDocument(NullSafetyHelper.castNonNull(LSPEclipseUtils.toTextDocumentIdentifier(this.document)));
            params.setNewName(newName);
            LanguageServerWrapper refactoringServer = this.refactoringServer;
            WorkspaceEdit rename = refactoringServer != null ? (this.rename = (WorkspaceEdit)refactoringServer.execute(ls -> ls.getTextDocumentService().rename(params)).get(1000L, TimeUnit.MILLISECONDS)) : (this.rename = (WorkspaceEdit)((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(this.document).withCapability(ServerCapabilities::getRenameProvider)).computeFirst(ls -> ls.getTextDocumentService().rename(params)).get(1000L, TimeUnit.MILLISECONDS).orElse(null));
            if (!status.hasError() && (rename == null || rename.getChanges().isEmpty() && rename.getDocumentChanges().isEmpty())) {
                status.addWarning(Messages.rename_empty_message);
            }
        }
        catch (Exception e) {
            status.addFatalError(this.getErrorMessage(e));
        }
        return status;
    }

    private String getErrorMessage(Throwable e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof ResponseErrorException) {
            Object object;
            ResponseErrorException responseErrorException = (ResponseErrorException)throwable;
            ResponseError responseError = responseErrorException.getResponseError();
            String string = responseError.getMessage();
            Object object2 = responseError.getData();
            if (object2 instanceof String) {
                String data = (String)object2;
                object = ": " + data;
            } else {
                object = "";
            }
            return string + (String)object;
        }
        String msg = e.getMessage();
        return msg != null ? msg : e.getClass().getSimpleName();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        WorkspaceEdit rename = this.rename;
        if (rename == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", Messages.rename_processor_required));
        }
        return LSPEclipseUtils.toCompositeChange(rename, Messages.rename_title);
    }

    public RefactoringParticipant @Nullable [] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return null;
    }

    public void setNewName(String newName) {
        Assert.isNotNull((Object)newName);
        this.newName = newName;
    }
}

