/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import jnr.unixsocket.UnixSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class UnixConnectionSocketFactory
implements ConnectionSocketFactory {
    private File socketFile;

    public UnixConnectionSocketFactory(URI socketUri) {
        String filename = socketUri.toString().replaceAll("^unix:///", "unix://localhost/").replaceAll("^unix://localhost", "");
        this.socketFile = new File(filename);
    }

    public static URI sanitizeUri(URI uri) {
        if (uri.getScheme().equals("unix")) {
            return URI.create("unix://localhost:80");
        }
        return uri;
    }

    public UnixSocket createSocket(HttpContext context) throws IOException {
        return UnixSocketChannel.open().socket();
    }

    public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        if (!(socket instanceof UnixSocket)) {
            throw new AssertionError((Object)("Unexpected socket: " + String.valueOf(socket)));
        }
        socket.setSoTimeout((int)connectTimeout.toDuration().toMillis());
        socket.getChannel().connect((SocketAddress)new UnixSocketAddress(this.socketFile));
        return socket;
    }
}

