/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement;

import jakarta.validation.Valid;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.ValidOnListAndOnTypeArgumentWithGroupConversions;
import org.hibernate.beanvalidation.tck.util.CollectionHelper;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class LegacyValidOnContainerCascadingTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)LegacyValidOnContainerCascadingTest.webArchiveBuilder().withTestClassPackage(LegacyValidOnContainerCascadingTest.class)).withPackage(ValidOnListAndOnTypeArgumentWithGroupConversions.class.getPackage())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i")})
    public void testValidOnList() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)ValidOnList.invalidValue(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitors").property("name", true, null, 0, List.class, 0)));
        constraintViolations = validator.validate((Object)ValidOnList.invalidSize(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("visitors"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i")})
    public void testValidOnListAndOnTypeArgument() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)ValidOnListAndOnTypeArgument.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitors").property("name", true, null, 0, List.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i")})
    public void testValidOnListWithoutTypeArgument() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)ValidOnListWithoutTypeArgument.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitors").property("name", true, null, 0, MyListWithoutTypeArgument.class, null)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i")})
    public void testValidOnIterableAndSet() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)ValidOnIterable.invalidValue(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitors").property("name", true, null, null, Set.class, 0)));
        constraintViolations = validator.validate((Object)ValidOnIterable.invalidSize(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("visitors"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="j")})
    public void testValidOnMap() {
        Validator validator = this.getValidator();
        Museum museum = Museum.invalid();
        Set constraintViolations = validator.validate((Object)ValidOnMap.invalidValue(museum), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitors").property("name", true, museum, null, Map.class, 1)));
        constraintViolations = validator.validate((Object)ValidOnMap.invalidSize(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("visitors"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i")})
    public void testValidOnArray() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)ValidOnArray.invalidValue(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitors").property("name", true, null, 0, Object[].class, null)));
        constraintViolations = validator.validate((Object)ValidOnArray.invalidSize(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("visitors"));
    }

    private static class ValidOnList {
        @Valid
        @Size(min=1)
        private final @Valid @Size(min=1) List<Visitor> visitors;

        private ValidOnList(List<Visitor> visitors) {
            this.visitors = visitors;
        }

        private static ValidOnList invalidValue() {
            return new ValidOnList(new ArrayList<Visitor>(Arrays.asList(new Visitor(null))));
        }

        private static ValidOnList invalidSize() {
            return new ValidOnList(Collections.emptyList());
        }
    }

    private static class ValidOnListAndOnTypeArgument {
        @Valid
        private final @Valid List<@Valid Visitor> visitors;

        private ValidOnListAndOnTypeArgument(List<Visitor> visitors) {
            this.visitors = visitors;
        }

        private static ValidOnListAndOnTypeArgument invalid() {
            return new ValidOnListAndOnTypeArgument(Arrays.asList(new Visitor(null)));
        }
    }

    private static class ValidOnListWithoutTypeArgument {
        @Valid
        private final MyListWithoutTypeArgument visitors;

        private ValidOnListWithoutTypeArgument(MyListWithoutTypeArgument visitors) {
            this.visitors = visitors;
        }

        private static ValidOnListWithoutTypeArgument invalid() {
            return new ValidOnListWithoutTypeArgument(new MyListWithoutTypeArgument(Arrays.asList(new Visitor(null))));
        }
    }

    private static class MyListWithoutTypeArgument
    extends ArrayList<Visitor> {
        private MyListWithoutTypeArgument(List<Visitor> elements) {
            this.addAll(elements);
        }
    }

    private static class ValidOnIterable {
        @Valid
        @Size(min=1)
        private final @Valid @Size(min=1) Set<Visitor> visitors;

        private ValidOnIterable(Set<Visitor> visitors) {
            this.visitors = visitors;
        }

        private static ValidOnIterable invalidValue() {
            return new ValidOnIterable(CollectionHelper.asSet(new Visitor(null)));
        }

        private static ValidOnIterable invalidSize() {
            return new ValidOnIterable(Collections.emptySet());
        }
    }

    private static class Museum {
        @NotNull
        private final String name;

        public Museum(String name) {
            this.name = name;
        }

        private static Museum invalid() {
            return new Museum(null);
        }
    }

    private static class ValidOnMap {
        @Valid
        @Size(min=1)
        private final @Valid @Size(min=1) Map<Museum, Visitor> visitors;

        private ValidOnMap(Map<Museum, Visitor> visitors) {
            this.visitors = visitors;
        }

        private static ValidOnMap invalidValue(Museum museum) {
            HashMap<Museum, Visitor> map = new HashMap<Museum, Visitor>();
            map.put(museum, new Visitor(null));
            return new ValidOnMap(map);
        }

        private static ValidOnMap invalidSize() {
            return new ValidOnMap(new HashMap<Museum, Visitor>());
        }
    }

    private static class ValidOnArray {
        @Valid
        @Size(min=1)
        private final @Valid @Size(min=1) Visitor[] visitors;

        private ValidOnArray(Visitor[] visitors) {
            this.visitors = visitors;
        }

        private static ValidOnArray invalidValue() {
            Visitor[] visitors = new Visitor[]{new Visitor(null)};
            return new ValidOnArray(visitors);
        }

        private static ValidOnArray invalidSize() {
            Visitor[] visitors = new Visitor[]{};
            return new ValidOnArray(visitors);
        }
    }

    private static class Visitor {
        @NotNull
        private final String name;

        private Visitor(String name) {
            this.name = name;
        }
    }
}

