/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.Validator;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class NotEmptyConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)NotEmptyConstraintTest.webArchiveBuilder().withTestClass(NotEmptyConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-notempty", id="a")})
    public void testNotEmptyConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NotEmptyDummyEntity dummy = new NotEmptyDummyEntity();
        dummy.collection = new HashSet<String>();
        dummy.string = "";
        dummy.stringBuilder = new StringBuilder();
        dummy.map = new HashMap<String, String>();
        dummy.integerArray = new Integer[0];
        dummy.booleanArray = new boolean[0];
        dummy.byteArray = new byte[0];
        dummy.charArray = new char[0];
        dummy.doubleArray = new double[0];
        dummy.floatArray = new float[0];
        dummy.intArray = new int[0];
        dummy.longArray = new long[0];
        dummy.shortArray = new short[0];
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("collection"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("map"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("string"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("stringBuilder"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("integerArray"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("booleanArray"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("byteArray"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("charArray"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("doubleArray"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("floatArray"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("intArray"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("longArray"), ConstraintViolationAssert.violationOf(NotEmpty.class).withProperty("shortArray"));
        dummy.collection.add("foo");
        dummy.string = "a";
        dummy.stringBuilder.append("a");
        dummy.map.put("key1", "value1");
        dummy.integerArray = new Integer[1];
        dummy.booleanArray = new boolean[1];
        dummy.byteArray = new byte[1];
        dummy.charArray = new char[1];
        dummy.doubleArray = new double[1];
        dummy.floatArray = new float[1];
        dummy.intArray = new int[1];
        dummy.longArray = new long[1];
        dummy.shortArray = new short[1];
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    private static class NotEmptyDummyEntity {
        @NotEmpty
        private String string;
        @NotEmpty
        private StringBuilder stringBuilder;
        @NotEmpty
        private Collection<String> collection;
        @NotEmpty
        private Map<String, String> map;
        @NotEmpty
        private Integer[] integerArray;
        @NotEmpty
        private boolean[] booleanArray;
        @NotEmpty
        private byte[] byteArray;
        @NotEmpty
        private char[] charArray;
        @NotEmpty
        private double[] doubleArray;
        @NotEmpty
        private float[] floatArray;
        @NotEmpty
        private int[] intArray;
        @NotEmpty
        private long[] longArray;
        @NotEmpty
        private short[] shortArray;

        private NotEmptyDummyEntity() {
        }
    }
}

