/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.clipboard.RequestClipboardDataAction;
import org.eclipse.glsp.server.features.clipboard.SetClipboardDataAction;
import org.eclipse.glsp.server.gson.GraphGsonConfigurationFactory;
import org.eclipse.glsp.server.model.GModelState;

public class GModelRequestClipboardDataActionHandler
extends AbstractActionHandler<RequestClipboardDataAction> {
    protected final Gson gson;
    @Inject
    protected GModelState modelState;

    @Inject
    public GModelRequestClipboardDataActionHandler(GraphGsonConfigurationFactory gsonConfigurator) {
        GsonBuilder builder = gsonConfigurator.configureGson();
        this.gson = builder.create();
    }

    @Override
    public List<Action> executeAction(RequestClipboardDataAction action) {
        JsonArray jsonArray = new JsonArray();
        GModelIndex index = this.modelState.getIndex();
        Set selectedElements = index.getAll(action.getEditorContext().getSelectedElementIds());
        selectedElements.stream().map(arg_0 -> ((Gson)this.gson).toJsonTree(arg_0)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return this.listOf(new SetClipboardDataAction(Collections.singletonMap("application/json", jsonArray.toString())));
    }
}

