/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.di;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.protocol.GLSPServerException;
import org.eclipse.glsp.server.utils.MultiRegistry;

public abstract class MapMultiRegistry<K, V>
implements MultiRegistry<K, V> {
    protected Map<K, List<V>> elements = new LinkedHashMap<K, List<V>>();

    @Override
    public boolean register(K key, V instance) {
        List instances = this.elements.computeIfAbsent(key, k -> new ArrayList());
        return instances.add(instance);
    }

    @Override
    public boolean deregister(K key, V instance) {
        List<V> instances = this.elements.get(key);
        return instances != null ? instances.remove(instance) : false;
    }

    @Override
    public boolean deregisterAll(K key) {
        return this.elements.remove(key) != null;
    }

    @Override
    public boolean hasKey(K key) {
        return this.elements.containsKey(key);
    }

    @Override
    public List<V> get(K key) {
        return this.elements.getOrDefault(key, new ArrayList());
    }

    @Override
    public List<V> getAll() {
        return this.elements.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected GLSPServerException missing(K key) {
        return new GLSPServerException("Unknown registry key: " + key);
    }
}

