/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.validation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.BasicActionHandler;
import org.eclipse.glsp.server.features.validation.Marker;
import org.eclipse.glsp.server.features.validation.ModelValidator;
import org.eclipse.glsp.server.features.validation.RequestMarkersAction;
import org.eclipse.glsp.server.features.validation.SetMarkersAction;
import org.eclipse.glsp.server.model.GModelState;

public class RequestMarkersHandler
extends BasicActionHandler<RequestMarkersAction> {
    @Inject
    protected ModelValidator validator;

    @Override
    public List<Action> executeAction(RequestMarkersAction action, GModelState modelState) {
        List<String> elementsIDs = action.getElementsIDs();
        if (elementsIDs == null || elementsIDs.size() == 0 || elementsIDs.size() == 1 && "EMPTY".equals(elementsIDs.get(0))) {
            elementsIDs = Arrays.asList(((GModelRoot)modelState.getRoot()).getId());
        }
        ArrayList<Marker> markers = new ArrayList<Marker>();
        GModelIndex currentModelIndex = modelState.getIndex();
        for (String elementID : elementsIDs) {
            Optional modelElement = currentModelIndex.get(elementID);
            if (!modelElement.isPresent()) continue;
            markers.addAll(this.validator.validate(modelState, (GModelElement)modelElement.get()));
        }
        return this.listOf(new SetMarkersAction(markers));
    }
}

