/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.labeledit;

import java.util.Set;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.server.features.directediting.LabelEditValidator;
import org.eclipse.glsp.server.features.directediting.ValidationStatus;
import org.eclipse.glsp.server.model.GModelState;

public class WorkflowLabelEditValidator
implements LabelEditValidator {
    public ValidationStatus validate(GModelState modelState, String label, GModelElement element) {
        if (label.length() < 1) {
            return ValidationStatus.error((String)"Name must not be empty");
        }
        Set taskNodes = modelState.getIndex().getAllByClass(TaskNode.class);
        boolean hasDuplicate = taskNodes.stream().filter(e -> !e.getId().equals(element.getId())).map(TaskNode::getName).anyMatch(name -> name.equals(label));
        if (hasDuplicate) {
            return ValidationStatus.warning((String)"Name should be unique");
        }
        return ValidationStatus.ok();
    }
}

