/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.graph.GBounds;
import org.eclipse.glsp.graph.GHtmlRoot;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GPreRenderedElement;
import org.eclipse.glsp.graph.GraphFactory;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.features.popup.PopupModelFactory;
import org.eclipse.glsp.server.features.popup.RequestPopupModelAction;
import org.eclipse.glsp.server.model.GModelState;

public class WorkflowPopupFactory
implements PopupModelFactory {
    private static final String NL = "<br>";

    private String generateTitle(TaskNode task) {
        return task.getName();
    }

    private String generateBody(TaskNode task) {
        return String.format("<br>Type: %s<br>Duration: %s<br> Reference: %s<br>", task.getTaskType(), task.getDuration(), task.getReference());
    }

    public Optional<GHtmlRoot> createPopupModel(GModelElement element, RequestPopupModelAction action, GModelState modelState) {
        if (element != null && element instanceof TaskNode) {
            TaskNode task = (TaskNode)element;
            GHtmlRoot root = GraphFactory.eINSTANCE.createGHtmlRoot();
            GBounds bounds = action.getBounds();
            root.setCanvasBounds(GraphUtil.bounds((double)bounds.getX(), (double)bounds.getY(), (double)bounds.getWidth(), (double)bounds.getHeight()));
            root.setType("html");
            root.setId("sprotty-popup");
            GPreRenderedElement p1 = GraphFactory.eINSTANCE.createGPreRenderedElement();
            p1.setType("pre-rendered");
            p1.setId("popup-title");
            p1.setCode("<div class=\"sprotty-popup-title\">" + this.generateTitle(task) + "</div>");
            GPreRenderedElement p2 = GraphFactory.eINSTANCE.createGPreRenderedElement();
            p2.setType("pre-rendered");
            p2.setId("popup-body");
            p2.setCode("<div class=\"sprotty-popup-body\">" + this.generateBody(task) + "</div>");
            root.getChildren().addAll(Arrays.asList(p1, p2));
            return Optional.of(root);
        }
        return Optional.empty();
    }
}

