/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractCollectionDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EcoreDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class EcoreListDescriptor
extends AbstractCollectionDescriptor
implements EcoreDescriptor,
UnboxedDescriptor {
    protected final @NonNull StandardLibrary standardLibrary;
    protected final @NonNull Type type;

    public EcoreListDescriptor(@NonNull CollectionTypeId collectionTypeId, @NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        super(collectionTypeId);
        this.standardLibrary = standardLibrary;
        this.type = type;
    }

    @Override
    public void append(@NonNull JavaStream js, @Nullable Boolean isRequired) {
        BoxedDescriptor elementTypeDescriptor = js.getCodeGenerator().getBoxedDescriptor((ElementId)((CollectionTypeId)this.elementId).getElementTypeId());
        js.appendClassReference(isRequired, List.class, false, elementTypeDescriptor);
    }

    @Override
    public void appendEcoreValue(@NonNull JavaStream js, @NonNull String requiredClassName, @NonNull CGValuedElement cgValue) {
        if (requiredClassName.startsWith(EList.class.getName())) {
            BoxedDescriptor boxedElementDescriptor = js.getCodeGenerator().getBoxedDescriptor((ElementId)this.type.getTypeId());
            js.append("(");
            js.appendClassReference(null, EList.class, false, boxedElementDescriptor);
            js.append(")");
        }
        js.appendValueName(cgValue);
    }

    @Override
    public void appendElement(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(this.getJavaClass());
    }

    @Override
    public @NonNull String getClassName() {
        return (String)ClassUtil.nonNullModel((Object)this.type.getName());
    }

    @Override
    public @NonNull EcoreDescriptor getEcoreDescriptor(@NonNull CodeGenerator codeGenerator, @Nullable Class<?> instanceClass) {
        return this;
    }

    @Override
    public @NonNull Class<?> getJavaClass() {
        return Object.class;
    }

    @Override
    public @NonNull UnboxedDescriptor getUnboxedDescriptor(@NonNull CodeGenerator codeGenerator) {
        return this;
    }

    @Override
    public @Nullable Class<?> hasJavaClass() {
        return null;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof EcoreListDescriptor)) {
            return false;
        }
        Type thatType = ((EcoreListDescriptor)typeDescriptor).type;
        return thatType.conformsTo(this.standardLibrary, this.type);
    }

    @Override
    public @NonNull String toString() {
        return this.elementId + " => /*E*/List<Object/*" + this.type.getName() + "*/>";
    }
}

