/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine.debug;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.DynamicFeatureRegistry;
import org.eclipse.emf.ecoretools.ale.core.interpreter.RuntimeInstanceHelper;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.gemoc.executionframework.debugger.IDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class AleDynamicAccessor
implements IDynamicPartAccessor {
    Map<EClass, EClass> baseToRuntime;
    ALEInterpreter interpreter;
    Map<EClass, Integer> counters = new HashMap<EClass, Integer>();
    List<RuntimeClass> dynamicClasses = null;

    public AleDynamicAccessor(ALEInterpreter interpreter, List<ModelUnit> allModelUnits) {
        List domain = interpreter.getQueryEnvironment().getEPackageProvider().getEClassifiers().stream().filter(cls -> cls instanceof EClass).map(cls -> (EClass)cls).collect(Collectors.toList());
        this.dynamicClasses = allModelUnits.stream().flatMap(unit -> unit.getClassDefinitions().stream()).collect(Collectors.toList());
        this.baseToRuntime = RuntimeInstanceHelper.getBaseToRuntime(allModelUnits, domain);
        this.interpreter = interpreter;
    }

    public List<MutableField> extractMutableField(EObject eObject) {
        MutableField field;
        Consumer<Object> setter;
        Supplier<Object> getter;
        ArrayList<MutableField> result = new ArrayList<MutableField>();
        if (eObject == null) {
            return result;
        }
        EClass runtimePart = this.baseToRuntime.get(eObject.eClass());
        if (runtimePart != null) {
            for (EStructuralFeature feature : runtimePart.getEStructuralFeatures()) {
                getter = () -> {
                    DynamicFeatureRegistry registry = this.interpreter.getCurrentEngine().getEvalEnvironment().getFeatureAccess();
                    return registry.aqlFeatureAccess(eObject, feature.getName());
                };
                setter = newValue -> {
                    DynamicFeatureRegistry registry = this.interpreter.getCurrentEngine().getEvalEnvironment().getFeatureAccess();
                    registry.setDynamicFeatureValue(eObject, feature.getName(), newValue);
                };
                field = new MutableField(String.valueOf(feature.getName()) + " (" + this.getName(eObject) + " :" + eObject.eClass().getName() + ")", eObject, feature, getter, setter);
                result.add(field);
            }
        }
        if (this.isDynamic(eObject)) {
            for (EStructuralFeature feature : eObject.eClass().getEStructuralFeatures()) {
                getter = () -> eObject.eGet(feature);
                setter = newValue -> eObject.eSet(feature, newValue);
                field = new MutableField(String.valueOf(feature.getName()) + " (" + this.getName(eObject) + " :" + eObject.eClass().getName() + ")", eObject, feature, getter, setter);
                result.add(field);
            }
        }
        return result;
    }

    private String getName(EObject eObject) {
        DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
        EAttribute idProp = eObject.eClass().getEIDAttribute();
        if (idProp != null) {
            Object id = eObject.eGet((EStructuralFeature)idProp);
            if (id != null) {
                DecimalFormat formatter = new DecimalFormat("00");
                String idString = id.toString();
                if (id instanceof Integer) {
                    idString = formatter.format((Integer)id);
                }
                return String.valueOf(eObject.eClass().getName()) + "_" + idString;
            }
            if (!this.counters.containsKey(eObject.eClass())) {
                this.counters.put(eObject.eClass(), 0);
            }
            Integer counter = this.counters.get(eObject.eClass());
            this.counters.put(eObject.eClass(), counter + 1);
            return String.valueOf(eObject.eClass().getName()) + "_" + counter;
        }
        QualifiedName qname = nameprovider.getFullyQualifiedName(eObject);
        if (qname == null) {
            return eObject.toString();
        }
        return qname.toString();
    }

    public boolean isDynamic(EObject obj) {
        if (obj == null) {
            return false;
        }
        String qualifiedClsName = this.getQualifiedName(obj.eClass());
        return this.dynamicClasses.stream().anyMatch(runtimeCls -> this.getQualifiedName((RuntimeClass)runtimeCls).equals(qualifiedClsName));
    }

    private String getQualifiedName(EClass cls) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(0, cls.getName());
        EPackage parent = cls.getEPackage();
        while (parent != null) {
            segments.add(0, parent.getName());
            parent = parent.getESuperPackage();
        }
        return String.join((CharSequence)".", segments);
    }

    private String getQualifiedName(RuntimeClass cls) {
        return String.valueOf(((ModelUnit)cls.eContainer()).getName()) + "." + cls.getName();
    }
}

