/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.eventscheduling.timeline.views.timeline;

import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gemoc.addon.eventscheduling.timeline.views.timeline.EventSchedulingTimelineProvider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.eventscheduling.trace.EventSchedulingModelExecutionTracingAddon;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.eventscheduling.trace.ModelExecutionTracingException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.AbstractUserDecider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionEngine;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.Branch;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.Choice;
import org.eclipse.gemoc.executionframework.ui.Activator;
import org.eclipse.gemoc.executionframework.ui.views.engine.IEngineSelectionListener;
import org.eclipse.gemoc.timeline.editpart.PossibleStepEditPart;
import org.eclipse.gemoc.timeline.editpart.TimelineEditPartFactory;
import org.eclipse.gemoc.timeline.view.AbstractTimelineView;
import org.eclipse.gemoc.timeline.view.ITimelineProvider;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IDisposable;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EventSchedulingTimeLineView
extends AbstractTimelineView
implements IEngineSelectionListener {
    public static final String ID = "org.eclipse.gemoc.addon.eventscheduling.timeline.views.timeline.EventSchedulingTimeLineView";
    public static final String FOLLOW_COMMAND_ID = "org.eclipse.gemoc.addon.eventscheduling.timeline.views.timeline.Follow";
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private IContentProvider _contentProvider;
    private ILabelProvider _labelProvider;
    private IExecutionEngine<?> _currentEngine;
    private WeakHashMap<IExecutionEngine<?>, Integer> _positions = new WeakHashMap();
    private ITimelineProvider _timelineProvider;
    private MouseListener _mouseListener = null;
    private TimelineEditPartFactory _factory;

    public EventSchedulingTimeLineView() {
        this._contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
        this._labelProvider = new AdapterFactoryLabelProvider(this.adapterFactory);
        IWorkbenchPage wbpage = this.getActivePage();
        IViewPart viewPart = wbpage.findView(ID);
        wbpage.activate((IWorkbenchPart)viewPart);
        wbpage.bringToTop((IWorkbenchPart)viewPart);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.startListeningToEngineSelectionChange();
        this.configure(Activator.getDefault().getEngineSelectionManager().get_lastSelectedEngine());
    }

    public void dispose() {
        this.disposeTimeLineProvider();
        this.removeDoubleClickListener();
        this.stopListeningToEngineSelectionChange();
        super.dispose();
        this._contentProvider.dispose();
        this._labelProvider.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setDetailViewerContentProvider(this._contentProvider);
        this.setDetailViewerLabelProvider(this._labelProvider);
        this._mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                EventSchedulingTimeLineView.this.handleDoubleCick();
            }
        };
        this.getTimelineViewer().getControl().addMouseListener(this._mouseListener);
    }

    private void startListeningToEngineSelectionChange() {
        Activator.getDefault().getEngineSelectionManager().addEngineSelectionListener((IEngineSelectionListener)this);
    }

    private void stopListeningToEngineSelectionChange() {
        Activator.getDefault().getEngineSelectionManager().removeEngineSelectionListener((IEngineSelectionListener)this);
    }

    public void configure(IExecutionEngine<?> engine) {
        if (engine != null && (this._currentEngine != engine || this._timelineProvider == null)) {
            this.saveStartIndex();
            this._currentEngine = engine;
            this.disposeTimeLineProvider();
            if (engine != null) {
                int start = this.getStartIndex(engine);
                if (this._timelineProvider == null) {
                    this._timelineProvider = new EventSchedulingTimelineProvider(engine);
                }
                this.setTimelineProvider(this._timelineProvider, start);
            }
        }
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private int getStartIndex(IExecutionEngine<?> engine) {
        int start = 0;
        if (this._positions.containsKey(engine)) {
            start = this._positions.get(engine);
        }
        return start;
    }

    private void saveStartIndex() {
        if (this._currentEngine != null) {
            this._positions.put(this._currentEngine, this.getStart());
        }
    }

    private void removeDoubleClickListener() {
        if (this._mouseListener != null && this.getTimelineViewer() != null && this.getTimelineViewer().getControl() != null) {
            this.getTimelineViewer().getControl().removeMouseListener(this._mouseListener);
        }
    }

    private void disposeTimeLineProvider() {
        if (this._timelineProvider != null) {
            ((IDisposable)this._timelineProvider).dispose();
            this._timelineProvider = null;
            this.setTimelineProvider(this._timelineProvider, 0);
        }
    }

    public void engineSelectionChanged(IExecutionEngine<?> engine) {
        this.update(engine);
    }

    private boolean canDisplayTimeline(IExecutionEngine<?> engine) {
        if (engine.getExecutionContext().getExecutionMode().equals((Object)ExecutionMode.Run) && engine.getRunningStatus().equals((Object)EngineStatus.RunStatus.Stopped)) {
            return true;
        }
        return engine.getExecutionContext().getExecutionMode().equals((Object)ExecutionMode.Animation);
    }

    public boolean hasDetailViewer() {
        return false;
    }

    public String getFollowCommandID() {
        return FOLLOW_COMMAND_ID;
    }

    private void handleDoubleCick() {
        Object selected;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof PossibleStepEditPart) {
            Object o1 = ((PossibleStepEditPart)selected).getModel().getChoice2();
            Object o2 = ((PossibleStepEditPart)selected).getModel().getPossibleStep();
            if (o1 instanceof Choice && o2 instanceof Step) {
                Choice choice = (Choice)o1;
                Step logicalStep = (Step)o2;
                if (this._currentEngine.getRunningStatus().equals((Object)EngineStatus.RunStatus.WaitingLogicalStepSelection)) {
                    if (choice.getSelectedNextChoice() == null) {
                        this.performExecutionStep(logicalStep);
                    } else {
                        Choice choiceToRestore = choice.getSelectedNextChoice();
                        this.branchIfPossible(choiceToRestore);
                    }
                }
            }
        }
    }

    private void performExecutionStep(Step<?> logicalStep) {
        IConcurrentExecutionEngine engine_cast;
        if (this._currentEngine instanceof IConcurrentExecutionEngine && (engine_cast = (IConcurrentExecutionEngine)this._currentEngine).getLogicalStepDecider() instanceof AbstractUserDecider) {
            AbstractUserDecider decider = (AbstractUserDecider)engine_cast.getLogicalStepDecider();
            decider.decideFromTimeLine(logicalStep);
        }
    }

    private void branchIfPossible(Choice choice) {
        if (this._currentEngine.hasAddon(EventSchedulingModelExecutionTracingAddon.class)) {
            EventSchedulingModelExecutionTracingAddon addon = (EventSchedulingModelExecutionTracingAddon)this._currentEngine.getAddon(EventSchedulingModelExecutionTracingAddon.class);
            try {
                Choice previousChoice = choice.getPreviousChoice();
                Branch previousBranch = previousChoice.getBranch();
                if (previousBranch.getChoices().indexOf((Object)previousChoice) == previousBranch.getChoices().size() - 2) {
                    addon.reintegrateBranch(choice);
                } else {
                    addon.branch(choice);
                }
            }
            catch (ModelExecutionTracingException e) {
                org.eclipse.gemoc.commons.eclipse.ui.Activator.error((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected TimelineEditPartFactory getTimelineEditPartFactory() {
        this._factory = new TimelineEditPartFactory(false);
        return this._factory;
    }

    public void update(IExecutionEngine<?> engine) {
        if (engine != null) {
            if (this.canDisplayTimeline(engine)) {
                this.configure(engine);
            } else {
                this.disposeTimeLineProvider();
            }
        }
    }
}

