/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import fr.inria.diverse.k3.al.annotationprocessor.Inv;
import fr.inria.diverse.k3.al.annotationprocessor.Post;
import fr.inria.diverse.k3.al.annotationprocessor.Pre;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ContractedProcessor extends AbstractClassProcessor {
  private List<MutableMethodDeclaration> invariants = CollectionLiterals.<MutableMethodDeclaration>newArrayList();
  
  private List<MutableMethodDeclaration> preConditions = CollectionLiterals.<MutableMethodDeclaration>newArrayList();
  
  private List<MutableMethodDeclaration> postConditions = CollectionLiterals.<MutableMethodDeclaration>newArrayList();
  
  @Extension
  private TransformationContext context;
  
  @Override
  public void doTransform(final MutableClassDeclaration annotatedCls, @Extension final TransformationContext ctx) {
    this.context = ctx;
    final Map<MutableMethodDeclaration, String> bodies = new HashMap<MutableMethodDeclaration, String>();
    this.getAllInvs(annotatedCls, this.invariants);
    final Function1<MutableMethodDeclaration, Boolean> _function = (MutableMethodDeclaration it) -> {
      final Function1<AnnotationReference, Boolean> _function_1 = (AnnotationReference it_1) -> {
        AnnotationTypeDeclaration _annotationTypeDeclaration = it_1.getAnnotationTypeDeclaration();
        Type _type = ctx.newTypeReference(Pre.class).getType();
        return Boolean.valueOf(Objects.equal(_annotationTypeDeclaration, _type));
      };
      return Boolean.valueOf(IterableExtensions.exists(it.getAnnotations(), _function_1));
    };
    Iterables.<MutableMethodDeclaration>addAll(this.preConditions, 
      IterableExtensions.filter(annotatedCls.getDeclaredMethods(), _function));
    final Function1<MutableMethodDeclaration, Boolean> _function_1 = (MutableMethodDeclaration it) -> {
      final Function1<AnnotationReference, Boolean> _function_2 = (AnnotationReference it_1) -> {
        AnnotationTypeDeclaration _annotationTypeDeclaration = it_1.getAnnotationTypeDeclaration();
        Type _type = ctx.newTypeReference(Post.class).getType();
        return Boolean.valueOf(Objects.equal(_annotationTypeDeclaration, _type));
      };
      return Boolean.valueOf(IterableExtensions.exists(it.getAnnotations(), _function_2));
    };
    Iterables.<MutableMethodDeclaration>addAll(this.postConditions, 
      IterableExtensions.filter(annotatedCls.getDeclaredMethods(), _function_1));
    boolean _check = this.check();
    boolean _not = (!_check);
    if (_not) {
      return;
    }
    int _size = this.invariants.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      final Function1<MutableMethodDeclaration, Boolean> _function_2 = (MutableMethodDeclaration it) -> {
        return Boolean.valueOf(((!it.isStatic()) && (!IterableExtensions.exists(it.getAnnotations(), 
          ((Function1<AnnotationReference, Boolean>) (AnnotationReference it_1) -> {
            Type _type = ctx.newTypeReference(Pre.class).getType();
            Type _type_1 = ctx.newTypeReference(Post.class).getType();
            Type _type_2 = ctx.newTypeReference(Inv.class).getType();
            return Boolean.valueOf(Collections.<Type>unmodifiableList(CollectionLiterals.<Type>newArrayList(_type, _type_1, _type_2)).contains(it_1.getAnnotationTypeDeclaration()));
          })))));
      };
      final Consumer<MutableMethodDeclaration> _function_3 = (MutableMethodDeclaration m) -> {
        String _firstUpper = StringExtensions.toFirstUpper(m.getSimpleName());
        String _plus = (ContractedProcessor.PREPRIV_PREFIX + _firstUpper);
        final Procedure1<MutableMethodDeclaration> _function_4 = (MutableMethodDeclaration it) -> {
          it.setVisibility(Visibility.PRIVATE);
          it.setStatic(m.isStatic());
          it.setFinal(m.isFinal());
          it.setReturnType(m.getReturnType());
          final Consumer<MutableParameterDeclaration> _function_5 = (MutableParameterDeclaration p) -> {
            it.addParameter(p.getSimpleName(), p.getType());
          };
          m.getParameters().forEach(_function_5);
          Expression _body = m.getBody();
          boolean _tripleEquals = (_body == null);
          if (_tripleEquals) {
            final CompilationStrategy _function_6 = (CompilationStrategy.CompilationContext it_1) -> {
              return bodies.get(m);
            };
            it.setBody(_function_6);
          } else {
            it.setBody(m.getBody());
          }
        };
        annotatedCls.addMethod(_plus, _function_4);
        String _simpleName = m.getReturnType().getSimpleName();
        final boolean isVoid = Objects.equal(_simpleName, "void");
        final ArrayList<MutableMethodDeclaration> preConditionsMethods = new ArrayList<MutableMethodDeclaration>();
        this.getAllPre(annotatedCls, preConditionsMethods, m.getSimpleName());
        final Function1<MutableMethodDeclaration, Boolean> _function_5 = (MutableMethodDeclaration preConditionMethod) -> {
          final Function1<MutableMethodDeclaration, Boolean> _function_6 = (MutableMethodDeclaration m_) -> {
            return Boolean.valueOf(Objects.equal(m_, preConditionMethod));
          };
          boolean _exists = IterableExtensions.exists(annotatedCls.getDeclaredMethods(), _function_6);
          return Boolean.valueOf((!_exists));
        };
        final Consumer<MutableMethodDeclaration> _function_6 = (MutableMethodDeclaration preConditionMethod) -> {
          final int randomIndex = new Random().nextInt(1000000);
          final String mName = preConditionMethod.getSimpleName();
          final String mNameWithIndex = (mName + Integer.valueOf(randomIndex));
          preConditionMethod.setSimpleName(mNameWithIndex);
          final Procedure1<MutableMethodDeclaration> _function_7 = (MutableMethodDeclaration it) -> {
            it.setReturnType(preConditionMethod.getReturnType());
            it.setStatic(false);
            it.setFinal(false);
            it.setVisibility(Visibility.PROTECTED);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return this.");
                _builder.append(mNameWithIndex);
                _builder.append("() ;");
                _builder.newLineIfNotEmpty();
              }
            };
            it.setBody(_client);
            it.addAnnotation(ctx.newAnnotationReference(ctx.newTypeReference(Pre.class).getType()));
          };
          preConditionMethod.getDeclaringType().addMethod(mName, _function_7);
        };
        IterableExtensions.<MutableMethodDeclaration>filter(preConditionsMethods, _function_5).forEach(_function_6);
        String _xifexpression = null;
        boolean _isEmpty = this.preConditions.isEmpty();
        if (_isEmpty) {
          _xifexpression = "true";
        } else {
          final Function1<MutableMethodDeclaration, String> _function_7 = (MutableMethodDeclaration it) -> {
            String _simpleName_1 = it.getSimpleName();
            return (_simpleName_1 + "()");
          };
          _xifexpression = IterableExtensions.join(ListExtensions.<MutableMethodDeclaration, String>map(preConditionsMethods, _function_7), " || ");
        }
        final String preConditionsExpr = _xifexpression;
        String _xifexpression_1 = null;
        boolean _isEmpty_1 = this.invariants.isEmpty();
        if (_isEmpty_1) {
          _xifexpression_1 = "true";
        } else {
          final Function1<MutableMethodDeclaration, String> _function_8 = (MutableMethodDeclaration it) -> {
            String _simpleName_1 = it.getSimpleName();
            return (_simpleName_1 + "()");
          };
          _xifexpression_1 = IterableExtensions.join(ListExtensions.<MutableMethodDeclaration, String>map(this.invariants, _function_8), " && ");
        }
        final String invariantsExpr = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        _builder.append(preConditionsExpr);
        _builder.append(" && ");
        _builder.append(invariantsExpr);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        {
          if ((!isVoid)) {
            _builder.append("return ");
          }
        }
        _builder.append(ContractedProcessor.PREPRIV_PREFIX, "    ");
        String _firstUpper_1 = StringExtensions.toFirstUpper(m.getSimpleName());
        _builder.append(_firstUpper_1, "    ");
        _builder.append("(");
        final Function1<MutableParameterDeclaration, String> _function_9 = (MutableParameterDeclaration it) -> {
          return it.getSimpleName();
        };
        String _join = IterableExtensions.join(IterableExtensions.map(m.getParameters(), _function_9), ", ");
        _builder.append(_join, "    ");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("throw new fr.inria.diverse.k3.al.annotationprocessor.PreConditionViolationException();");
        _builder.newLine();
        final String wrappedBody = _builder.toString();
        final CompilationStrategy _function_10 = (CompilationStrategy.CompilationContext it) -> {
          return wrappedBody;
        };
        m.setBody(_function_10);
        bodies.put(m, wrappedBody);
        String _firstUpper_2 = StringExtensions.toFirstUpper(m.getSimpleName());
        String _plus_1 = (ContractedProcessor.POSTPRIV_PREFIX + _firstUpper_2);
        final Procedure1<MutableMethodDeclaration> _function_11 = (MutableMethodDeclaration it) -> {
          it.setVisibility(Visibility.PRIVATE);
          it.setStatic(m.isStatic());
          it.setFinal(m.isFinal());
          it.setReturnType(m.getReturnType());
          Expression _body = m.getBody();
          boolean _tripleEquals = (_body == null);
          if (_tripleEquals) {
            final CompilationStrategy _function_12 = (CompilationStrategy.CompilationContext it_1) -> {
              return bodies.get(m);
            };
            it.setBody(_function_12);
          } else {
            it.setBody(m.getBody());
          }
          final Consumer<MutableParameterDeclaration> _function_13 = (MutableParameterDeclaration p) -> {
            it.addParameter(p.getSimpleName(), p.getType());
          };
          m.getParameters().forEach(_function_13);
        };
        annotatedCls.addMethod(_plus_1, _function_11);
        final ArrayList<MutableMethodDeclaration> postConditionsMethods = new ArrayList<MutableMethodDeclaration>();
        this.getAllPost(annotatedCls, postConditionsMethods, m.getSimpleName());
        final Function1<MutableMethodDeclaration, Boolean> _function_12 = (MutableMethodDeclaration postConditionMethod) -> {
          final Function1<MutableMethodDeclaration, Boolean> _function_13 = (MutableMethodDeclaration m_) -> {
            return Boolean.valueOf(Objects.equal(m_, postConditionMethod));
          };
          boolean _exists = IterableExtensions.exists(annotatedCls.getDeclaredMethods(), _function_13);
          return Boolean.valueOf((!_exists));
        };
        final Consumer<MutableMethodDeclaration> _function_13 = (MutableMethodDeclaration postConditionMethod) -> {
          final int randomIndex = new Random().nextInt(1000000);
          final String mName = postConditionMethod.getSimpleName();
          final String mNameWithIndex = (mName + Integer.valueOf(randomIndex));
          postConditionMethod.setSimpleName(mNameWithIndex);
          final Procedure1<MutableMethodDeclaration> _function_14 = (MutableMethodDeclaration it) -> {
            it.setReturnType(postConditionMethod.getReturnType());
            it.setStatic(false);
            it.setFinal(false);
            it.setVisibility(Visibility.PROTECTED);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return this.");
                _builder.append(mNameWithIndex);
                _builder.append("() ;");
                _builder.newLineIfNotEmpty();
              }
            };
            it.setBody(_client);
            it.addAnnotation(ctx.newAnnotationReference(ctx.newTypeReference(Post.class).getType()));
          };
          postConditionMethod.getDeclaringType().addMethod(mName, _function_14);
        };
        IterableExtensions.<MutableMethodDeclaration>filter(postConditionsMethods, _function_12).forEach(_function_13);
        String _xifexpression_2 = null;
        boolean _isEmpty_2 = postConditionsMethods.isEmpty();
        if (_isEmpty_2) {
          _xifexpression_2 = "true";
        } else {
          final Function1<MutableMethodDeclaration, String> _function_14 = (MutableMethodDeclaration it) -> {
            String _simpleName_1 = it.getSimpleName();
            return (_simpleName_1 + "()");
          };
          _xifexpression_2 = IterableExtensions.join(ListExtensions.<MutableMethodDeclaration, String>map(postConditionsMethods, _function_14), " && ");
        }
        final String postConditionsExpr = _xifexpression_2;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            {
              if ((!isVoid)) {
                String _name = m.getReturnType().getName();
                _builder.append(_name);
                _builder.append(" __ret = ");
              }
            }
            _builder.append(ContractedProcessor.POSTPRIV_PREFIX);
            String _firstUpper = StringExtensions.toFirstUpper(m.getSimpleName());
            _builder.append(_firstUpper);
            _builder.append("(");
            final Function1<MutableParameterDeclaration, String> _function = (MutableParameterDeclaration it) -> {
              return it.getSimpleName();
            };
            String _join = IterableExtensions.join(IterableExtensions.map(m.getParameters(), _function), ", ");
            _builder.append(_join);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("if (!(");
            _builder.append(postConditionsExpr);
            _builder.append(" && ");
            _builder.append(invariantsExpr);
            _builder.append("))");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("throw new fr.inria.diverse.k3.al.annotationprocessor.PostConditionViolationException();");
            _builder.newLine();
            {
              if ((!isVoid)) {
                _builder.append("return __ret;");
              }
            }
            _builder.newLineIfNotEmpty();
          }
        };
        m.setBody(_client);
      };
      IterableExtensions.filter(annotatedCls.getDeclaredMethods(), _function_2).forEach(_function_3);
    } else {
      final Consumer<MutableMethodDeclaration> _function_4 = (MutableMethodDeclaration annotatedMethod) -> {
        final Function1<MutableMethodDeclaration, Boolean> _function_5 = (MutableMethodDeclaration it) -> {
          String _simpleName = it.getSimpleName();
          String _firstLower = StringExtensions.toFirstLower(annotatedMethod.getSimpleName().substring(3));
          return Boolean.valueOf(Objects.equal(_simpleName, _firstLower));
        };
        final MutableMethodDeclaration m = IterableExtensions.findFirst(annotatedMethod.getDeclaringType().getDeclaredMethods(), _function_5);
        MutableTypeDeclaration _declaringType = annotatedMethod.getDeclaringType();
        String _firstUpper = StringExtensions.toFirstUpper(m.getSimpleName());
        String _plus = (ContractedProcessor.PREPRIV_PREFIX + _firstUpper);
        final Procedure1<MutableMethodDeclaration> _function_6 = (MutableMethodDeclaration it) -> {
          it.setVisibility(Visibility.PRIVATE);
          it.setStatic(m.isStatic());
          it.setFinal(m.isFinal());
          it.setReturnType(m.getReturnType());
          Expression _body = m.getBody();
          boolean _tripleEquals = (_body == null);
          if (_tripleEquals) {
            final CompilationStrategy _function_7 = (CompilationStrategy.CompilationContext it_1) -> {
              return bodies.get(m);
            };
            it.setBody(_function_7);
          } else {
            it.setBody(m.getBody());
          }
          final Consumer<MutableParameterDeclaration> _function_8 = (MutableParameterDeclaration p) -> {
            it.addParameter(p.getSimpleName(), p.getType());
          };
          m.getParameters().forEach(_function_8);
        };
        _declaringType.addMethod(_plus, _function_6);
        String _simpleName = m.getReturnType().getSimpleName();
        final boolean isVoid = Objects.equal(_simpleName, "void");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        _builder.append(ContractedProcessor.PRE_PREFIX);
        String _firstUpper_1 = StringExtensions.toFirstUpper(m.getSimpleName());
        _builder.append(_firstUpper_1);
        _builder.append("())");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        {
          if ((!isVoid)) {
            _builder.append("return ");
          }
        }
        _builder.append(ContractedProcessor.PREPRIV_PREFIX, "\t");
        String _firstUpper_2 = StringExtensions.toFirstUpper(m.getSimpleName());
        _builder.append(_firstUpper_2, "\t");
        _builder.append("(");
        final Function1<MutableParameterDeclaration, String> _function_7 = (MutableParameterDeclaration it) -> {
          return it.getSimpleName();
        };
        String _join = IterableExtensions.join(IterableExtensions.map(m.getParameters(), _function_7), ", ");
        _builder.append(_join, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("throw new fr.inria.diverse.k3.al.annotationprocessor.PreConditionViolationException();");
        _builder.newLine();
        final String wrappedBody = _builder.toString();
        final CompilationStrategy _function_8 = (CompilationStrategy.CompilationContext it) -> {
          return wrappedBody;
        };
        m.setBody(_function_8);
        bodies.put(m, wrappedBody);
      };
      this.preConditions.forEach(_function_4);
      final Consumer<MutableMethodDeclaration> _function_5 = (MutableMethodDeclaration annotatedMethod) -> {
        final Function1<MutableMethodDeclaration, Boolean> _function_6 = (MutableMethodDeclaration it) -> {
          String _simpleName = it.getSimpleName();
          String _firstLower = StringExtensions.toFirstLower(annotatedMethod.getSimpleName().substring(4));
          return Boolean.valueOf(Objects.equal(_simpleName, _firstLower));
        };
        final MutableMethodDeclaration m = IterableExtensions.findFirst(annotatedMethod.getDeclaringType().getDeclaredMethods(), _function_6);
        MutableTypeDeclaration _declaringType = annotatedMethod.getDeclaringType();
        String _firstUpper = StringExtensions.toFirstUpper(m.getSimpleName());
        String _plus = (ContractedProcessor.POSTPRIV_PREFIX + _firstUpper);
        final Procedure1<MutableMethodDeclaration> _function_7 = (MutableMethodDeclaration it) -> {
          it.setVisibility(Visibility.PRIVATE);
          it.setStatic(m.isStatic());
          it.setFinal(m.isFinal());
          it.setReturnType(m.getReturnType());
          Expression _body = m.getBody();
          boolean _tripleEquals = (_body == null);
          if (_tripleEquals) {
            final CompilationStrategy _function_8 = (CompilationStrategy.CompilationContext it_1) -> {
              return bodies.get(m);
            };
            it.setBody(_function_8);
          } else {
            it.setBody(m.getBody());
          }
          final Consumer<MutableParameterDeclaration> _function_9 = (MutableParameterDeclaration p) -> {
            it.addParameter(p.getSimpleName(), p.getType());
          };
          m.getParameters().forEach(_function_9);
        };
        _declaringType.addMethod(_plus, _function_7);
        String _simpleName = m.getReturnType().getSimpleName();
        final boolean isVoid = Objects.equal(_simpleName, "void");
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            {
              if ((!isVoid)) {
                String _name = m.getReturnType().getName();
                _builder.append(_name);
                _builder.append(" __ret = ");
              }
            }
            _builder.append(ContractedProcessor.POSTPRIV_PREFIX);
            String _firstUpper = StringExtensions.toFirstUpper(m.getSimpleName());
            _builder.append(_firstUpper);
            _builder.append("(");
            final Function1<MutableParameterDeclaration, String> _function = (MutableParameterDeclaration it) -> {
              return it.getSimpleName();
            };
            String _join = IterableExtensions.join(IterableExtensions.map(m.getParameters(), _function), ", ");
            _builder.append(_join);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("if (!");
            _builder.append(ContractedProcessor.POST_PREFIX);
            String _firstUpper_1 = StringExtensions.toFirstUpper(m.getSimpleName());
            _builder.append(_firstUpper_1);
            _builder.append("())");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("throw new fr.inria.diverse.k3.al.annotationprocessor.PostConditionViolationException();");
            _builder.newLine();
            {
              if ((!isVoid)) {
                _builder.append("return __ret;");
              }
            }
            _builder.newLineIfNotEmpty();
          }
        };
        m.setBody(_client);
      };
      this.postConditions.forEach(_function_5);
    }
    this.invariants.clear();
    this.preConditions.clear();
    this.postConditions.clear();
  }
  
  public boolean check() {
    for (final MutableMethodDeclaration annotatedMethod : this.invariants) {
      {
        int _size = IterableExtensions.size(annotatedMethod.getParameters());
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          this.context.addError(annotatedMethod, "Invariant methods cannot declare any parameter");
          return false;
        }
        String _simpleName = annotatedMethod.getReturnType().getSimpleName();
        boolean _notEquals = (!Objects.equal(_simpleName, "boolean"));
        if (_notEquals) {
          this.context.addError(annotatedMethod, "Invariant methods must return a boolean value");
          return false;
        }
      }
    }
    for (final MutableMethodDeclaration annotatedMethod_1 : this.preConditions) {
      {
        int _size = IterableExtensions.size(annotatedMethod_1.getParameters());
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          this.context.addError(annotatedMethod_1, "Precondition methods cannot declare any parameter");
          return false;
        }
        TypeReference _returnType = annotatedMethod_1.getReturnType();
        TypeReference _newTypeReference = this.context.newTypeReference("boolean");
        boolean _notEquals = (!Objects.equal(_returnType, _newTypeReference));
        if (_notEquals) {
          this.context.addError(annotatedMethod_1, "Precondition methods must return a boolean value");
          return false;
        }
        if (((!annotatedMethod_1.getSimpleName().startsWith(ContractedProcessor.PRE_PREFIX)) || (!Character.isUpperCase(annotatedMethod_1.getSimpleName().charAt(3))))) {
          this.context.addError(annotatedMethod_1, ("Precondition methods must be prefixed with " + ContractedProcessor.PRE_PREFIX));
          return false;
        }
        final Function1<MutableMethodDeclaration, Boolean> _function = (MutableMethodDeclaration it) -> {
          String _simpleName = it.getSimpleName();
          String _firstLower = StringExtensions.toFirstLower(annotatedMethod_1.getSimpleName().substring(3));
          return Boolean.valueOf(Objects.equal(_simpleName, _firstLower));
        };
        boolean _exists = IterableExtensions.exists(annotatedMethod_1.getDeclaringType().getDeclaredMethods(), _function);
        boolean _not = (!_exists);
        if (_not) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Cannot find referenced contracted method ");
          String _firstLower = StringExtensions.toFirstLower(annotatedMethod_1.getSimpleName().substring(3));
          _builder.append(_firstLower);
          this.context.addError(annotatedMethod_1, _builder.toString());
          return false;
        }
      }
    }
    for (final MutableMethodDeclaration annotatedMethod_2 : this.postConditions) {
      {
        int _size = IterableExtensions.size(annotatedMethod_2.getParameters());
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          this.context.addError(annotatedMethod_2, "Postcondition methods cannot declare any parameter");
          return false;
        }
        TypeReference _returnType = annotatedMethod_2.getReturnType();
        TypeReference _newTypeReference = this.context.newTypeReference("boolean");
        boolean _notEquals = (!Objects.equal(_returnType, _newTypeReference));
        if (_notEquals) {
          this.context.addError(annotatedMethod_2, "Postcondition methods must return a boolean value");
          return false;
        }
        if (((!annotatedMethod_2.getSimpleName().startsWith(ContractedProcessor.POST_PREFIX)) || (!Character.isUpperCase(annotatedMethod_2.getSimpleName().charAt(4))))) {
          this.context.addError(annotatedMethod_2, ("Postcondition methods must be prefixed with " + ContractedProcessor.POST_PREFIX));
          return false;
        }
        final Function1<MutableMethodDeclaration, Boolean> _function = (MutableMethodDeclaration it) -> {
          String _simpleName = it.getSimpleName();
          String _firstLower = StringExtensions.toFirstLower(annotatedMethod_2.getSimpleName().substring(4));
          return Boolean.valueOf(Objects.equal(_simpleName, _firstLower));
        };
        boolean _exists = IterableExtensions.exists(annotatedMethod_2.getDeclaringType().getDeclaredMethods(), _function);
        boolean _not = (!_exists);
        if (_not) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Cannot find referenced contracted method ");
          String _firstLower = StringExtensions.toFirstLower(annotatedMethod_2.getSimpleName().substring(4));
          _builder.append(_firstLower);
          this.context.addError(annotatedMethod_2, _builder.toString());
          return false;
        }
      }
    }
    return true;
  }
  
  private void getAllInvs(final MutableClassDeclaration cls, final List<MutableMethodDeclaration> invs) {
    final Function1<MutableMethodDeclaration, Boolean> _function = (MutableMethodDeclaration it) -> {
      final Function1<AnnotationReference, Boolean> _function_1 = (AnnotationReference it_1) -> {
        AnnotationTypeDeclaration _annotationTypeDeclaration = it_1.getAnnotationTypeDeclaration();
        Type _type = this.context.newTypeReference(Inv.class).getType();
        return Boolean.valueOf(Objects.equal(_annotationTypeDeclaration, _type));
      };
      return Boolean.valueOf(IterableExtensions.exists(it.getAnnotations(), _function_1));
    };
    Iterables.<MutableMethodDeclaration>addAll(invs, IterableExtensions.filter(cls.getDeclaredMethods(), _function));
    TypeReference _extendedClass = cls.getExtendedClass();
    boolean _tripleNotEquals = (_extendedClass != null);
    if (_tripleNotEquals) {
      final MutableClassDeclaration parent = this.context.findClass(cls.getExtendedClass().getName());
      if ((parent != null)) {
        this.getAllInvs(parent, invs);
      }
    }
  }
  
  private void getAllPre(final MutableClassDeclaration cls, final List<MutableMethodDeclaration> pres, final String methodName) {
    final Function1<MutableMethodDeclaration, Boolean> _function = (MutableMethodDeclaration it) -> {
      String _simpleName = it.getSimpleName();
      String _firstUpper = StringExtensions.toFirstUpper(methodName);
      String _plus = (ContractedProcessor.PRE_PREFIX + _firstUpper);
      return Boolean.valueOf(Objects.equal(_simpleName, _plus));
    };
    Iterables.<MutableMethodDeclaration>addAll(pres, IterableExtensions.filter(cls.getDeclaredMethods(), _function));
    TypeReference _extendedClass = cls.getExtendedClass();
    boolean _tripleNotEquals = (_extendedClass != null);
    if (_tripleNotEquals) {
      final MutableClassDeclaration parent = this.context.findClass(cls.getExtendedClass().getName());
      if ((parent != null)) {
        this.getAllPre(parent, pres, methodName);
      }
    }
  }
  
  private void getAllPost(final MutableClassDeclaration cls, final List<MutableMethodDeclaration> posts, final String methodName) {
    final Function1<MutableMethodDeclaration, Boolean> _function = (MutableMethodDeclaration it) -> {
      String _simpleName = it.getSimpleName();
      String _firstUpper = StringExtensions.toFirstUpper(methodName);
      String _plus = (ContractedProcessor.POST_PREFIX + _firstUpper);
      return Boolean.valueOf(Objects.equal(_simpleName, _plus));
    };
    Iterables.<MutableMethodDeclaration>addAll(posts, IterableExtensions.filter(cls.getDeclaredMethods(), _function));
    TypeReference _extendedClass = cls.getExtendedClass();
    boolean _tripleNotEquals = (_extendedClass != null);
    if (_tripleNotEquals) {
      final MutableClassDeclaration parent = this.context.findClass(cls.getExtendedClass().getName());
      if ((parent != null)) {
        this.getAllPost(parent, posts, methodName);
      }
    }
  }
  
  private final static String PRE_PREFIX = "pre";
  
  private final static String POST_PREFIX = "post";
  
  private final static String PREPRIV_PREFIX = "prepriv";
  
  private final static String POSTPRIV_PREFIX = "postpriv";
}
