/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class TraceMMExplorer {
  private final EPackage tracemm;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass stateClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificStateClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificTraceClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificTracedObjectClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificDimensionClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificStepClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificRootStepClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificValueClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificAttributeValueClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificReferenceValueClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EReference dimensionsReference;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EPackage stepsPackage;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EPackage statesPackage;
  
  protected final EFactory rootFactory;
  
  protected final EFactory stepFactory;
  
  protected final EFactory stateFactory;
  
  /**
   * Here we focus on the part of the base trace mm, because TraceMMExplorer is
   * used in the TraceMMGenerator as well.
   */
  public TraceMMExplorer(final EPackage traceMetamodel) {
    this.tracemm = traceMetamodel;
    TreeIterator<EObject> _eAllContents = this.tracemm.eAllContents();
    Iterator<EClass> _filter = Iterators.<EClass>filter(_eAllContents, EClass.class);
    final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_Trace));
      }
    };
    EClass _findFirst = IteratorExtensions.<EClass>findFirst(_filter, _function);
    this.specificTraceClass = ((EClass) _findFirst);
    TreeIterator<EObject> _eAllContents_1 = this.tracemm.eAllContents();
    Iterator<EClass> _filter_1 = Iterators.<EClass>filter(_eAllContents_1, EClass.class);
    final Function1<EClass, Boolean> _function_1 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_SpecificState));
      }
    };
    EClass _findFirst_1 = IteratorExtensions.<EClass>findFirst(_filter_1, _function_1);
    this.specificStateClass = ((EClass) _findFirst_1);
    EList<EClass> _eAllSuperTypes = this.specificStateClass.getEAllSuperTypes();
    Iterable<EClass> _filter_2 = Iterables.<EClass>filter(_eAllSuperTypes, EClass.class);
    final Function1<EClass, Boolean> _function_2 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_State));
      }
    };
    EClass _findFirst_2 = IterableExtensions.<EClass>findFirst(_filter_2, _function_2);
    this.stateClass = ((EClass) _findFirst_2);
    TreeIterator<EObject> _eAllContents_2 = this.tracemm.eAllContents();
    Iterator<EClass> _filter_3 = Iterators.<EClass>filter(_eAllContents_2, EClass.class);
    final Function1<EClass, Boolean> _function_3 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_TracedObject));
      }
    };
    EClass _findFirst_3 = IteratorExtensions.<EClass>findFirst(_filter_3, _function_3);
    this.specificTracedObjectClass = ((EClass) _findFirst_3);
    EList<EReference> _eAllContainments = this.specificTracedObjectClass.getEAllContainments();
    final Function1<EReference, Boolean> _function_4 = new Function1<EReference, Boolean>() {
      @Override
      public Boolean apply(final EReference r) {
        String _name = r.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.ref_Dimensions));
      }
    };
    EReference _findFirst_4 = IterableExtensions.<EReference>findFirst(_eAllContainments, _function_4);
    this.dimensionsReference = _findFirst_4;
    TreeIterator<EObject> _eAllContents_3 = this.tracemm.eAllContents();
    Iterator<EClass> _filter_4 = Iterators.<EClass>filter(_eAllContents_3, EClass.class);
    final Function1<EClass, Boolean> _function_5 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_Dimension));
      }
    };
    EClass _findFirst_5 = IteratorExtensions.<EClass>findFirst(_filter_4, _function_5);
    this.specificDimensionClass = ((EClass) _findFirst_5);
    TreeIterator<EObject> _eAllContents_4 = this.tracemm.eAllContents();
    Iterator<EClass> _filter_5 = Iterators.<EClass>filter(_eAllContents_4, EClass.class);
    final Function1<EClass, Boolean> _function_6 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_Value));
      }
    };
    EClass _findFirst_6 = IteratorExtensions.<EClass>findFirst(_filter_5, _function_6);
    this.specificValueClass = ((EClass) _findFirst_6);
    TreeIterator<EObject> _eAllContents_5 = this.tracemm.eAllContents();
    Iterator<EClass> _filter_6 = Iterators.<EClass>filter(_eAllContents_5, EClass.class);
    final Function1<EClass, Boolean> _function_7 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_AttributeValue));
      }
    };
    EClass _findFirst_7 = IteratorExtensions.<EClass>findFirst(_filter_6, _function_7);
    this.specificAttributeValueClass = ((EClass) _findFirst_7);
    TreeIterator<EObject> _eAllContents_6 = this.tracemm.eAllContents();
    Iterator<EClass> _filter_7 = Iterators.<EClass>filter(_eAllContents_6, EClass.class);
    final Function1<EClass, Boolean> _function_8 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_ReferenceValue));
      }
    };
    EClass _findFirst_8 = IteratorExtensions.<EClass>findFirst(_filter_7, _function_8);
    this.specificReferenceValueClass = ((EClass) _findFirst_8);
    TreeIterator<EObject> _eAllContents_7 = this.tracemm.eAllContents();
    Iterator<EClass> _filter_8 = Iterators.<EClass>filter(_eAllContents_7, EClass.class);
    final Function1<EClass, Boolean> _function_9 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_Step));
      }
    };
    EClass _findFirst_9 = IteratorExtensions.<EClass>findFirst(_filter_8, _function_9);
    this.specificStepClass = ((EClass) _findFirst_9);
    EPackage _ePackage = this.specificStepClass.getEPackage();
    this.stepsPackage = _ePackage;
    TreeIterator<EObject> _eAllContents_8 = this.tracemm.eAllContents();
    Iterator<EClass> _filter_9 = Iterators.<EClass>filter(_eAllContents_8, EClass.class);
    final Function1<EClass, Boolean> _function_10 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        String _name = c.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.class_RootStep));
      }
    };
    EClass _findFirst_10 = IteratorExtensions.<EClass>findFirst(_filter_9, _function_10);
    this.specificRootStepClass = ((EClass) _findFirst_10);
    TreeIterator<EObject> _eAllContents_9 = this.tracemm.eAllContents();
    Iterator<EPackage> _filter_10 = Iterators.<EPackage>filter(_eAllContents_9, EPackage.class);
    final Function1<EPackage, Boolean> _function_11 = new Function1<EPackage, Boolean>() {
      @Override
      public Boolean apply(final EPackage p) {
        String _name = p.getName();
        return Boolean.valueOf(_name.equals(TraceMMStrings.package_States));
      }
    };
    EPackage _findFirst_11 = IteratorExtensions.<EPackage>findFirst(_filter_10, _function_11);
    this.statesPackage = ((EPackage) _findFirst_11);
    EFactory _eFactoryInstance = this.tracemm.getEFactoryInstance();
    this.rootFactory = _eFactoryInstance;
    EFactory _eFactoryInstance_1 = this.stepsPackage.getEFactoryInstance();
    this.stepFactory = _eFactoryInstance_1;
    EFactory _eFactoryInstance_2 = this.statesPackage.getEFactoryInstance();
    this.stateFactory = _eFactoryInstance_2;
  }
  
  private boolean initDone = false;
  
  public void init() {
    if ((!this.initDone)) {
      HashSet<EClass> _hashSet = new HashSet<EClass>();
      this.stepClassesCache = _hashSet;
      TreeIterator<EObject> _eAllContents = this.stepsPackage.eAllContents();
      Iterator<EClass> _filter = Iterators.<EClass>filter(_eAllContents, EClass.class);
      final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
        @Override
        public Boolean apply(final EClass c) {
          return Boolean.valueOf((!Objects.equal(c, TraceMMExplorer.this.specificStepClass)));
        }
      };
      Iterator<EClass> _filter_1 = IteratorExtensions.<EClass>filter(_filter, _function);
      Set<EClass> _set = IteratorExtensions.<EClass>toSet(_filter_1);
      this.stepClassesCache.addAll(_set);
      EList<EReference> _eAllReferences = this.specificStateClass.getEAllReferences();
      final Function1<EReference, Boolean> _function_1 = new Function1<EReference, Boolean>() {
        @Override
        public Boolean apply(final EReference r) {
          String _name = r.getName();
          boolean _equals = _name.equals(TraceMMStrings.ref_ValueToStates);
          return Boolean.valueOf((!_equals));
        }
      };
      Iterable<EReference> _filter_2 = IterableExtensions.<EReference>filter(_eAllReferences, _function_1);
      Set<EReference> _set_1 = IterableExtensions.<EReference>toSet(_filter_2);
      this.refs_valueRefsFromStateClassCache = _set_1;
      this.initDone = true;
    }
  }
  
  private Set<EClass> stepClassesCache = null;
  
  public Set<EClass> stepClasses() {
    this.init();
    return this.stepClassesCache;
  }
  
  private final Map<EClass, EReference> stepSequenceRefOfCache = new HashMap<EClass, EReference>();
  
  public EReference stepSequenceRefOf(final EClass stepClass) {
    boolean _containsKey = this.stepSequenceRefOfCache.containsKey(stepClass);
    boolean _not = (!_containsKey);
    if (_not) {
      EList<EReference> _eReferences = this.specificTraceClass.getEReferences();
      final Function1<EReference, Boolean> _function = new Function1<EReference, Boolean>() {
        @Override
        public Boolean apply(final EReference r) {
          String _name = r.getName();
          String _ref_createTraceClassToStepClass = TraceMMStrings.ref_createTraceClassToStepClass(stepClass);
          return Boolean.valueOf(_name.equals(_ref_createTraceClassToStepClass));
        }
      };
      EReference _findFirst = IterableExtensions.<EReference>findFirst(_eReferences, _function);
      this.stepSequenceRefOfCache.put(stepClass, _findFirst);
    }
    return this.stepSequenceRefOfCache.get(stepClass);
  }
  
  public EObject createEventOccurrence(final EClass stepClass) {
    return this.stepFactory.create(stepClass);
  }
  
  public EObject createTracedObject(final EClass tracedClass) {
    EPackage _ePackage = tracedClass.getEPackage();
    EFactory _eFactoryInstance = _ePackage.getEFactoryInstance();
    return _eFactoryInstance.create(tracedClass);
  }
  
  public EObject createState(final EClass stateClass) {
    return this.stateFactory.create(stateClass);
  }
  
  private Set<EReference> refs_valueRefsFromStateClassCache;
  
  public Set<EReference> refs_valueRefsFromStateClass() {
    this.init();
    return this.refs_valueRefsFromStateClassCache;
  }
  
  private final Map<EClass, Set<EReference>> refs_originalObjectCache = new HashMap<EClass, Set<EReference>>();
  
  public Set<EReference> refs_originalObject(final EClass traceClass) {
    boolean _containsKey = this.refs_originalObjectCache.containsKey(traceClass);
    boolean _not = (!_containsKey);
    if (_not) {
      EList<EReference> _eAllReferences = traceClass.getEAllReferences();
      final Function1<EReference, Boolean> _function = new Function1<EReference, Boolean>() {
        @Override
        public Boolean apply(final EReference r) {
          String _name = r.getName();
          return Boolean.valueOf(_name.startsWith(TraceMMStrings.ref_OriginalObject));
        }
      };
      Iterable<EReference> _filter = IterableExtensions.<EReference>filter(_eAllReferences, _function);
      Set<EReference> _set = IterableExtensions.<EReference>toSet(_filter);
      this.refs_originalObjectCache.put(traceClass, _set);
    }
    return this.refs_originalObjectCache.get(traceClass);
  }
  
  @Pure
  public EClass getStateClass() {
    return this.stateClass;
  }
  
  @Pure
  public EClass getSpecificStateClass() {
    return this.specificStateClass;
  }
  
  @Pure
  public EClass getSpecificTraceClass() {
    return this.specificTraceClass;
  }
  
  @Pure
  public EClass getSpecificTracedObjectClass() {
    return this.specificTracedObjectClass;
  }
  
  @Pure
  public EClass getSpecificDimensionClass() {
    return this.specificDimensionClass;
  }
  
  @Pure
  public EClass getSpecificStepClass() {
    return this.specificStepClass;
  }
  
  @Pure
  public EClass getSpecificRootStepClass() {
    return this.specificRootStepClass;
  }
  
  @Pure
  public EClass getSpecificValueClass() {
    return this.specificValueClass;
  }
  
  @Pure
  public EClass getSpecificAttributeValueClass() {
    return this.specificAttributeValueClass;
  }
  
  @Pure
  public EClass getSpecificReferenceValueClass() {
    return this.specificReferenceValueClass;
  }
  
  @Pure
  public EReference getDimensionsReference() {
    return this.dimensionsReference;
  }
  
  @Pure
  public EPackage getStepsPackage() {
    return this.stepsPackage;
  }
  
  @Pure
  public EPackage getStatesPackage() {
    return this.statesPackage;
  }
}
