/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.validation;

import com.google.common.base.Objects;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.DslPackage;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.validation.AbstractDslValidator;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.ILanguageComponentValidator;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.LanguageComponentHelper;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Message;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Severity;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DslValidator
extends AbstractDslValidator {
    public static final String MISSING_NAME = "missingName";
    public static final String MISSING_KEY = "missingKey";
    public static final String DUPLICATEKEY = "duplicateKey";
    public final LanguageComponentHelper languageHelper = new LanguageComponentHelper();

    @Check
    public void checkDSLHasName(Dsl dsl) {
        boolean _isEmpty = dsl.getName().isEmpty();
        if (_isEmpty) {
            this.error("Missing an entry \"name\"", (EStructuralFeature)DslPackage.Literals.DSL__NAME, MISSING_NAME, new String[0]);
        }
    }

    @Check
    public void checkDuplicateKeys(Entry entry) {
        boolean _not;
        EObject _eContainer = entry.eContainer();
        Dsl dsl = (Dsl)_eContainer;
        Functions.Function1 _function = e -> {
            String _key = e.getKey();
            String _key_1 = entry.getKey();
            return Objects.equal((Object)_key, (Object)_key_1);
        };
        Functions.Function1 _function_1 = e -> e == entry;
        boolean _forall = IterableExtensions.forall((Iterable)IterableExtensions.filter((Iterable)dsl.getEntries(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        boolean bl = _not = !_forall;
        if (_not) {
            String _key = entry.getKey();
            String _plus = "Duplicate key \"" + _key;
            String _plus_1 = String.valueOf(_plus) + "\"";
            this.error(_plus_1, (EStructuralFeature)DslPackage.Literals.ENTRY__KEY, DUPLICATEKEY, new String[0]);
        }
    }

    @Check
    public void checkForEntry(Entry entry) {
        try {
            EObject dsl = entry.eContainer();
            if (dsl instanceof Dsl) {
                ArrayList<IConfigurationElement> _keys = this.getKeys((Dsl)dsl);
                for (IConfigurationElement key : _keys) {
                    Object _createExecutableExtension = key.createExecutableExtension("validationRule");
                    ILanguageComponentValidator rule = (ILanguageComponentValidator)_createExecutableExtension;
                    Message message = rule.validate(entry);
                    Severity _severity = message.getSeverity();
                    if (_severity != null) {
                        switch (_severity) {
                            case ERROR: {
                                this.error(message.getContent(), (EStructuralFeature)DslPackage.Literals.ENTRY__VALUE);
                                break;
                            }
                            case WARNING: {
                                this.warning(message.getContent(), (EStructuralFeature)DslPackage.Literals.ENTRY__VALUE);
                                break;
                            }
                            case INFO: {
                                this.info(message.getContent(), (EStructuralFeature)DslPackage.Literals.ENTRY__VALUE);
                                break;
                            }
                            case DEFAULT: {
                                Message _message;
                                message = _message = new Message();
                                break;
                            }
                            default: {
                                InputOutput.print((Object)"Unknown severity");
                                break;
                            }
                        }
                        continue;
                    }
                    InputOutput.print((Object)"Unknown severity");
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Check
    public void checkForApproachEntry(Dsl dsl) {
        Functions.Function1 _function = e -> {
            String _key = e.getKey();
            return Objects.equal((Object)_key, (Object)"metaprog");
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)dsl.getEntries(), (Functions.Function1)_function));
        if (_isEmpty) {
            this.warning("Missing \"metaprog\" entry to define the metaprogramming approach used", (EStructuralFeature)DslPackage.Literals.DSL__NAME);
        }
    }

    @Check
    public void checkApproach(Entry entry) {
        ArrayList<String> approachesList = new ArrayList<String>();
        boolean _matches = "metaprog".matches(entry.getKey());
        if (_matches) {
            boolean _not;
            IConfigurationElement[] exts;
            IConfigurationElement[] iConfigurationElementArray = exts = this.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                approachesList.add(elem.getAttribute("name"));
                ++n2;
            }
            boolean _contains = approachesList.contains(entry.getValue());
            boolean bl = _not = !_contains;
            if (_not) {
                this.error("Unknown metaprogramming approach", (EStructuralFeature)DslPackage.Literals.ENTRY__VALUE);
            }
        }
    }

    @Check
    public void checkMissingKeys(Dsl dsl) {
        ArrayList<String> dslKeys = new ArrayList<String>();
        EList _entries = dsl.getEntries();
        for (Entry entry : _entries) {
            dslKeys.add(entry.getKey());
        }
        ArrayList<IConfigurationElement> keys = this.getKeys(dsl);
        for (IConfigurationElement elem : keys) {
            String name = elem.getAttribute("name");
            if (dslKeys.contains(name) || !"false".matches(elem.getAttribute("optional"))) continue;
            this.error("Missing entry " + name + " in the dsl file.", (EStructuralFeature)DslPackage.Literals.DSL__NAME, MISSING_KEY, new String[0]);
        }
    }

    public IConfigurationElement[] getExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.gemoc_language_workbench.metaprog");
    }

    public String getApproach(Dsl dsl) {
        EList _entries = dsl.getEntries();
        for (Entry entry : _entries) {
            boolean _matches = "metaprog".matches(entry.getKey());
            if (!_matches) continue;
            return entry.getValue();
        }
        return null;
    }

    public ArrayList<IConfigurationElement> getKeys(Dsl dsl) {
        return this.languageHelper.getFullApproachKeys(this.getApproach(dsl));
    }
}

