/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.m2m;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.helpers.SpecificationBuildHelper;
import org.eclipse.gemoc.xdsmlframework.ui.utils.ENamedElementQualifiedNameLabelProvider;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.FlatContainerStyleDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class Ecore2BasicObjectDiagramSpecification {
    String diagramName;
    Viewpoint viewpoint;
    List<EClass> eClasses;
    List<EPackage> ePackages;
    String rootEClassAQLName;
    public String layerName = "Default";
    List<EClass> leafEClasses;
    protected HashMap<EClass, ContainerMapping> eClass2ContainerMap = new HashMap();

    public Ecore2BasicObjectDiagramSpecification(Viewpoint viewpoint, String diagramName, List<EClass> eClasses, List<EPackage> ePackages, String rootEClassAQLName) {
        this.viewpoint = viewpoint;
        this.diagramName = diagramName;
        this.eClasses = eClasses;
        this.ePackages = ePackages;
        this.rootEClassAQLName = rootEClassAQLName;
    }

    public void addBasicObjectDiagram() {
        DiagramDescription diag = SpecificationBuildHelper.createDiagram(this.viewpoint, this.diagramName);
        diag.setDomainClass(this.rootEClassAQLName);
        diag.getMetamodel().addAll(this.ePackages);
        diag.setDefaultLayer((Layer)SpecificationBuildHelper.createAdditionalLayer(this.layerName));
        ENamedElementQualifiedNameLabelProvider nameProvider = new ENamedElementQualifiedNameLabelProvider();
        this.leafEClasses = this.eClasses.stream().filter(c -> !Ecore2BasicObjectDiagramSpecification.hasKnownSubClass(c, this.eClasses) && !nameProvider.getText(c).equals(this.rootEClassAQLName)).collect(Collectors.toList());
        for (EClass anEClass : this.leafEClasses) {
            ContainerMapping node = SpecificationBuildHelper.createContainerMapping(diag, String.valueOf(anEClass.getName()) + "Container");
            this.eClass2ContainerMap.put(anEClass, node);
            node.setDomainClass(String.valueOf(anEClass.getEPackage().getName()) + "::" + anEClass.getName());
            FlatContainerStyleDescription gradientStyle = SpecificationBuildHelper.createFlatContainerStyleDescription(node);
            gradientStyle.setLabelExpression("aql:self.name+' : '+self.eClass().name");
        }
        for (EClass anEClass : this.eClasses) {
            List allApplicableLeafEClasses = this.leafEClasses.stream().filter(e -> e.getEAllSuperTypes().contains((Object)anEClass) || e.equals(anEClass)).collect(Collectors.toList());
            if (allApplicableLeafEClasses.isEmpty()) continue;
            for (EReference reference : anEClass.getEReferences()) {
                List allApplicableTargetLeafEClasses = this.leafEClasses.stream().filter(e -> e.getEAllSuperTypes().contains((Object)reference.getEReferenceType()) || e.equals(reference.getEReferenceType())).collect(Collectors.toList());
                if (allApplicableLeafEClasses.isEmpty() || allApplicableTargetLeafEClasses.isEmpty()) continue;
                EdgeMapping em = SpecificationBuildHelper.createEdgeMapping(diag, String.valueOf(anEClass.getName()) + "_" + reference.getName() + "Edge");
                allApplicableLeafEClasses.stream().map(leafClass -> this.eClass2ContainerMap.get(leafClass));
                em.getSourceMapping().addAll((Collection)allApplicableLeafEClasses.stream().map(leafClass -> this.eClass2ContainerMap.get(leafClass)).collect(Collectors.toList()));
                em.getTargetMapping().addAll((Collection)allApplicableTargetLeafEClasses.stream().map(targetleafClass -> this.eClass2ContainerMap.get(targetleafClass)).collect(Collectors.toList()));
                em.setTargetFinderExpression("feature:" + reference.getName());
                EdgeStyleDescription styleDesc = SpecificationBuildHelper.createStyleDescription(em);
                SpecificationBuildHelper.createCenterLabelStyleDescription(styleDesc, "aql:'" + reference.getName() + "'");
            }
        }
    }

    public static boolean hasKnownSubClass(EClass anEClass, List<EClass> consideredEClasses) {
        return consideredEClasses.stream().anyMatch(possibleSubClass -> possibleSubClass.getEAllSuperTypes().contains((Object)anEClass));
    }
}

