/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.internal.query.AbstractNodeMappingApplicabilityTester;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.viewpoint.DMappingBased;

public class NodeCreationDescriptionQuery {
    private NodeCreationDescription tool;

    public NodeCreationDescriptionQuery(NodeCreationDescription tool) {
        this.tool = tool;
    }

    public boolean canCreateIn(DDiagram diagram) {
        return new AbstractNodeMappingApplicabilityTester((Iterable<? extends AbstractNodeMapping>)this.tool.getNodeMappings()).canCreateIn(diagram);
    }

    public boolean canCreateIn(DDiagramElementContainer container) {
        if (this.checkExtraMappings((AbstractDNode)container)) {
            return true;
        }
        return new AbstractNodeMappingApplicabilityTester((Iterable<? extends AbstractNodeMapping>)this.tool.getNodeMappings()).canCreateIn(container);
    }

    private boolean checkExtraMappings(AbstractDNode nodeOrContainer) {
        for (AbstractNodeMapping extrMapping : this.tool.getExtraMappings()) {
            DiagramElementMappingQuery extraMappingQuery = new DiagramElementMappingQuery((DiagramElementMapping)extrMapping);
            if (!extraMappingQuery.isInstanceOf((DMappingBased)nodeOrContainer)) continue;
            return true;
        }
        return false;
    }

    public boolean canCreateIn(DNode node) {
        if (this.checkExtraMappings((AbstractDNode)node)) {
            return true;
        }
        return new AbstractNodeMappingApplicabilityTester((Iterable<? extends AbstractNodeMapping>)this.tool.getNodeMappings()).canCreateIn(node);
    }
}

