/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialog
extends IconAndMessageDialog {
    public static boolean AUTOMATED_MODE = false;
    private static final String NESTING_INDENT = "  ";
    private Button detailsButton;
    private String title;
    private org.eclipse.swt.widgets.List list;
    private boolean listCreated = false;
    private int displayMask = 65535;
    private IStatus status;
    private Clipboard clipboard;
    private boolean shouldIncludeTopLevelErrorInDetails = false;

    public ErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
        super(parentShell);
        this.title = dialogTitle == null ? JFaceResources.getString("Problem_Occurred") : dialogTitle;
        this.message = message == null ? status.getMessage() : JFaceResources.format("Reason", message, status.getMessage());
        this.status = status;
        this.displayMask = displayMask;
    }

    @Override
    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createDetailsButton(parent);
    }

    private void createSupportArea(Composite parent) {
        ErrorSupportProvider provider = Policy.getErrorSupportProvider();
        if (provider == null) {
            return;
        }
        if (!provider.validFor(this.status)) {
            return;
        }
        Composite supportArea = new Composite(parent, 0);
        provider.createSupportArea(supportArea, this.status);
        GridData supportData = new GridData(4, 4, true, true);
        supportData.verticalSpan = 3;
        supportArea.setLayoutData((Object)supportData);
        if (supportArea.getLayout() == null) {
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            supportArea.setLayout((Layout)layout);
        }
    }

    protected void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createMessageArea(composite);
        this.createSupportArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        childData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    @Override
    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    @Override
    protected Image getImage() {
        if (this.status != null) {
            if (this.status.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (this.status.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    protected org.eclipse.swt.widgets.List createDropDownList(Composite parent) {
        this.list = new org.eclipse.swt.widgets.List(parent, 2818);
        this.populateList(this.list);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        data.horizontalSpan = 2;
        this.list.setLayoutData((Object)data);
        this.list.setFont(parent.getFont());
        Menu copyMenu = new Menu((Control)this.list);
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorDialog.this.copyToClipboard();
            }
        });
        copyItem.setText(JFaceResources.getString("copy"));
        this.list.setMenu(copyMenu);
        this.listCreated = true;
        return this.list;
    }

    @Override
    public int open() {
        if (AUTOMATED_MODE) {
            IllegalStateException e = new IllegalStateException("Error dialog is supposed to be shown now");
            MultiStatus ms = new MultiStatus("org.eclipse.jface", 4, String.valueOf(this.title) + " : " + this.message, (Throwable)e);
            if (this.status != null) {
                ms.add(this.status);
            }
            Policy.getLog().log((IStatus)ms);
        }
        if (!AUTOMATED_MODE && ErrorDialog.shouldDisplay(this.status, this.displayMask)) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    public static int openError(Shell parent, String dialogTitle, String message, IStatus status) {
        return ErrorDialog.openError(parent, dialogTitle, message, status, 7);
    }

    public static int openError(Shell parentShell, String title, String message, IStatus status, int displayMask) {
        ErrorDialog dialog = new ErrorDialog(parentShell, title, message, status, displayMask);
        return dialog.open();
    }

    private void populateList(org.eclipse.swt.widgets.List listToPopulate) {
        this.populateList(listToPopulate, this.status, 0, this.shouldIncludeTopLevelErrorInDetails);
    }

    private boolean listContentExists() {
        return this.listContentExists(this.status, this.shouldIncludeTopLevelErrorInDetails);
    }

    private void populateList(org.eclipse.swt.widgets.List listToPopulate, IStatus buildingStatus, int nesting, boolean includeStatus) {
        String message;
        StringBuilder sb;
        if (!buildingStatus.matches(this.displayMask)) {
            return;
        }
        Throwable t = buildingStatus.getException();
        boolean incrementNesting = false;
        if (includeStatus) {
            sb = new StringBuilder();
            int i = 0;
            while (i < nesting) {
                sb.append(NESTING_INDENT);
                ++i;
            }
            message = buildingStatus.getMessage();
            sb.append(message);
            List<String> lines = ErrorDialog.readLines(sb.toString());
            for (String line : lines) {
                listToPopulate.add(line);
            }
            incrementNesting = true;
        }
        if (!(t instanceof CoreException) && t != null) {
            sb = new StringBuilder();
            int i = 0;
            while (i < nesting) {
                sb.append(NESTING_INDENT);
                ++i;
            }
            message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            sb.append(message);
            listToPopulate.add(sb.toString());
            incrementNesting = true;
        }
        if (incrementNesting) {
            ++nesting;
        }
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            IStatus eStatus = ce.getStatus();
            if (this.message == null || !this.message.contains(eStatus.getMessage())) {
                this.populateList(listToPopulate, eStatus, nesting, true);
            }
        }
        IStatus[] children = buildingStatus.getChildren();
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            this.populateList(listToPopulate, element, nesting, true);
            ++n2;
        }
    }

    private static List<String> readLines(String s) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(s));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                lines.add(line);
            }
        }
        catch (IOException iOException) {}
        return lines;
    }

    private boolean listContentExists(IStatus buildingStatus, boolean includeStatus) {
        IStatus[] children;
        if (!buildingStatus.matches(this.displayMask)) {
            return false;
        }
        Throwable t = buildingStatus.getException();
        if (includeStatus) {
            return true;
        }
        if (t != null && !(t instanceof CoreException)) {
            return true;
        }
        boolean result = false;
        if (t != null) {
            CoreException ce = (CoreException)t;
            IStatus eStatus = ce.getStatus();
            if (this.message == null || !this.message.contains(eStatus.getMessage())) {
                result |= this.listContentExists(eStatus, true);
            }
        }
        IStatus[] iStatusArray = children = buildingStatus.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            result |= this.listContentExists(element, true);
            ++n2;
        }
        return result;
    }

    protected static boolean shouldDisplay(IStatus status, int mask) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status.matches(mask);
        }
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            if (element.matches(mask)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void toggleDetailsArea() {
        boolean opened = false;
        Point windowSize = this.getShell().getSize();
        if (this.listCreated) {
            this.list.dispose();
            this.listCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
            opened = false;
        } else {
            this.list = this.createDropDownList((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            this.getContents().getShell().layout();
            opened = true;
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        int diffY = newSize.y - windowSize.y;
        if (opened && diffY > 0 || !opened && diffY < 0) {
            this.getShell().setSize(new Point(windowSize.x, windowSize.y + diffY));
        }
    }

    private void populateCopyBuffer(IStatus buildingStatus, StringBuilder buffer, int nesting) {
        IStatus[] children;
        if (!buildingStatus.matches(this.displayMask)) {
            return;
        }
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING_INDENT);
            ++i;
        }
        buffer.append(buildingStatus.getMessage());
        buffer.append("\n");
        Throwable t = buildingStatus.getException();
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            this.populateCopyBuffer(ce.getStatus(), buffer, nesting + 1);
        } else if (t != null) {
            int i2 = 0;
            while (i2 < nesting) {
                buffer.append(NESTING_INDENT);
                ++i2;
            }
            String message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            buffer.append(message);
            buffer.append("\n");
        }
        IStatus[] iStatusArray = children = buildingStatus.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            this.populateCopyBuffer(element, buffer, nesting + 1);
            ++n2;
        }
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        StringBuilder statusBuffer = new StringBuilder();
        this.populateCopyBuffer(this.status, statusBuffer, 0);
        this.clipboard = new Clipboard(this.list.getDisplay());
        this.clipboard.setContents(new Object[]{statusBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    @Override
    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.listCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return this.listContentExists();
    }

    protected final void setStatus(IStatus status) {
        if (this.status != status) {
            this.status = status;
        }
        this.shouldIncludeTopLevelErrorInDetails = true;
        if (this.listCreated) {
            this.repopulateList();
        }
    }

    private void repopulateList() {
        if (this.list != null && !this.list.isDisposed()) {
            this.list.removeAll();
            this.populateList(this.list);
        }
    }

    @Override
    protected int getColumnCount() {
        if (Policy.getErrorSupportProvider() == null) {
            return 2;
        }
        return 3;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }
}

