/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.ui.launcher;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.BiPredicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.commons.eclipse.ui.ViewHelper;
import org.eclipse.gemoc.dsl.debug.ide.IDSLDebugger;
import org.eclipse.gemoc.dsl.debug.ide.event.DSLDebugEventDispatcher;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.launch.AbstractDSLLaunchConfigurationDelegateSiriusUI;
import org.eclipse.gemoc.executionframework.debugger.AnnotationMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.GenericSequentialModelDebugger;
import org.eclipse.gemoc.executionframework.debugger.IntrospectiveMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.OmniscientGenericSequentialModelDebugger;
import org.eclipse.gemoc.executionframework.engine.ui.Activator;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtension;

public abstract class AbstractGemocLauncher<C extends IExecutionContext<?, ?, ?>>
extends AbstractDSLLaunchConfigurationDelegateSiriusUI {
    public static final String MODEL_ID = "org.eclipse.gemoc.executionframework.engine.ui.debugModel";

    public abstract IExecutionEngine<C> getExecutionEngine();

    protected void openViewsRecommandedByAddons(IRunConfiguration runConfiguration) {
        for (EngineAddonSpecificationExtension extension : runConfiguration.getEngineAddonExtensions()) {
            for (String viewId : extension.getOpenViewIds()) {
                ViewHelper.showView((String)viewId);
            }
        }
    }

    protected IDSLDebugger getDebugger(ILaunchConfiguration configuration, DSLDebugEventDispatcher dispatcher, EObject firstInstruction, IProgressMonitor monitor) {
        IExecutionEngine<C> engine = this.getExecutionEngine();
        Set traceAddons = engine.getAddonsTypedBy(IMultiDimensionalTraceAddon.class);
        traceAddons.removeIf(traceAddon -> traceAddon.getTraceConstructor() != null && traceAddon.getTraceConstructor().isPartialTraceConstructor());
        Object res = traceAddons.isEmpty() ? new GenericSequentialModelDebugger((IDSLDebugEventProcessor)dispatcher, engine) : new OmniscientGenericSequentialModelDebugger((IDSLDebugEventProcessor)dispatcher, engine);
        ArrayList<Object> extractors = new ArrayList<Object>();
        extractors.add(new AnnotationMutableFieldExtractor());
        extractors.add(new IntrospectiveMutableFieldExtractor(this.getExecutionEngine().getExecutionContext().getRunConfiguration().getLanguageName()));
        res.setMutableFieldExtractors(extractors);
        try {
            if (configuration.getAttribute("GEMOC_LAUNCH_BREAK_START", false)) {
                res.addPredicateBreak(new BiPredicate<IExecutionEngine<?>, Step<?>>(){

                    @Override
                    public boolean test(IExecutionEngine<?> t, Step<?> u) {
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
        Activator.getDefault().getMessaggingSystem().debug("Enabled implicit addon: " + res.getAddonID(), this.getPluginID());
        this.getExecutionEngine().getExecutionContext().getExecutionPlatform().addEngineAddon((IEngineAddon)res);
        return res;
    }
}

