/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.templates.specification;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.commons.eclipse.emf.URIHelper;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.AbstractStringWithButtonOption;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.TemplateOption;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.Activator;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.m2m.Ecore2BasicObjectDiagramSpecification;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.NewGemocSiriusProjectWizardFields;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.templates.SiriusTemplateSection;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.templates.TemplateMessages;
import org.eclipse.gemoc.xdsmlframework.ui.utils.ENamedElementQualifiedNameLabelProvider;
import org.eclipse.gemoc.xdsmlframework.ui.utils.dialogs.SelectAnyEObjectDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.EcoreUtil2;

public class BasicObjectDiagramTemplate
extends SiriusTemplateSection {
    public static final String KEY_DIAGRAM_NAME = "diagramName";
    public static final String KEY_DIAGRAM_ROOT_ECLASS = "diagramRootEClass";
    public static final String KEY_ECOREFILE_PATH = "ecoreFilePath";
    protected static final List<String> FILE_EXTENSIONS = Arrays.asList("ecore");
    NewGemocSiriusProjectWizardFields mainPagesData;
    IFile ecoreIFile;
    String diagramRootEClassName;

    public BasicObjectDiagramTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public String getSectionId() {
        return "miniAspectSample";
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    private void createOptions() {
        this.addOption(KEY_DIAGRAM_NAME, TemplateMessages.BasicObjectDiagramTemplate_diagramName, "BasicObjectDiagram", 0);
        AbstractStringWithButtonOption ecoreLocationOption = new AbstractStringWithButtonOption((BaseOptionTemplateSection)this, KEY_ECOREFILE_PATH, TemplateMessages.BasicObjectDiagramTemplate_ecoreFilePath){

            public String doSelectButton() {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Object selection = null;
                if (workbenchWindow.getSelectionService().getSelection() instanceof IStructuredSelection) {
                    selection = ((IStructuredSelection)workbenchWindow.getSelectionService().getSelection()).getFirstElement();
                }
                final IFile selectedEcoreFile = selection != null && selection instanceof IFile && FILE_EXTENSIONS.contains(((IFile)selection).getFileExtension()) ? (IFile)selection : null;
                ViewerFilter viewerFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IFile) {
                            IFile file = (IFile)element;
                            return FILE_EXTENSIONS.contains(file.getFileExtension()) && (selectedEcoreFile == null || !selectedEcoreFile.getFullPath().equals((Object)file.getFullPath()));
                        }
                        return true;
                    }
                };
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)workbenchWindow.getShell(), null, (String)"Select ecore", (boolean)true, null, Collections.singletonList(viewerFilter));
                if (files.length > 0) {
                    BasicObjectDiagramTemplate.this.ecoreIFile = files[0];
                    return files[0].getFullPath().toOSString();
                }
                return null;
            }
        };
        this.registerOption((TemplateOption)ecoreLocationOption, null, 0);
        AbstractStringWithButtonOption rootEClassOption = new AbstractStringWithButtonOption((BaseOptionTemplateSection)this, KEY_DIAGRAM_ROOT_ECLASS, TemplateMessages.BasicObjectDiagramTemplate_diagramRootEClass){

            public String doSelectButton() {
                Resource ecoreRes = EMFResource.getResource((IFile)BasicObjectDiagramTemplate.this.ecoreIFile);
                ENamedElementQualifiedNameLabelProvider labelProvider = new ENamedElementQualifiedNameLabelProvider();
                SelectAnyEObjectDialog dialog = new SelectAnyEObjectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ecoreRes.getResourceSet(), (ILabelProvider)labelProvider){

                    protected boolean select(EObject obj) {
                        return obj instanceof EClass;
                    }
                };
                int res = dialog.open();
                if (res == 0) {
                    EObject selection = (EObject)dialog.getFirstResult();
                    BasicObjectDiagramTemplate.this.diagramRootEClassName = labelProvider.getText((Object)selection);
                    return BasicObjectDiagramTemplate.this.diagramRootEClassName;
                }
                return null;
            }
        };
        this.registerOption((TemplateOption)rootEClassOption, null, 0);
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.basic_object_diagram");
        page.setTitle(TemplateMessages.BasicObjectDiagramTemplate_title);
        page.setDescription(TemplateMessages.BasicObjectDiagramTemplate_desc);
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    protected void initializeFields(BaseProjectWizardFields data) {
        Resource ecoreRes;
        Optional<EClass> eClass;
        String[] ecores;
        Resource res;
        Dsl dsl;
        Optional<Entry> ecore;
        this.mainPagesData = (NewGemocSiriusProjectWizardFields)data;
        if (this.ecoreIFile != null) {
            this.initializeOption(KEY_ECOREFILE_PATH, this.ecoreIFile.getFullPath().toOSString());
        }
        if (this.mainPagesData.dslFilePath != null && !this.mainPagesData.dslFilePath.isEmpty() && (ecore = (dsl = (Dsl)(res = new ResourceSetImpl().getResource(URI.createURI((String)this.mainPagesData.dslFilePath), true)).getContents().get(0)).getEntries().stream().filter(entry -> entry.getKey().equals("ecore")).findFirst()).isPresent() && (ecores = ecore.get().getValue().split(",")).length > 0) {
            String ecoreUri = ecores[0];
            String path = URIHelper.removePlatformScheme((URI)URI.createURI((String)ecoreUri));
            this.initializeOption(KEY_ECOREFILE_PATH, path);
            this.ecoreIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        if ((eClass = EcoreUtil2.eAllContentsAsList((Resource)(ecoreRes = EMFResource.getResource((IFile)this.ecoreIFile))).stream().filter(e -> e instanceof EClass).map(e -> (EClass)e).findAny()).isPresent()) {
            this.initializeOption(KEY_DIAGRAM_ROOT_ECLASS, new ENamedElementQualifiedNameLabelProvider().getText((Object)eClass.get()));
        }
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.actionSets";
    }

    @Override
    public String[] getNewFiles() {
        return new String[]{"icons/"};
    }

    @Override
    protected void generateFiles(IProgressMonitor monitor) throws CoreException {
        super.generateFiles(monitor);
        FileFinderVisitor visitor = new FileFinderVisitor("odesign");
        this.project.accept((IResourceVisitor)visitor);
        this.project.exists();
        IFile file = visitor.getFile();
        if (file != null) {
            try {
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                if (editor instanceof IEditingDomainProvider) {
                    EditingDomain editingDomain = ((IEditingDomainProvider)editor).getEditingDomain();
                    ResourceSet resourceSet = editingDomain.getResourceSet();
                    Group group = null;
                    block2: for (Resource resource : resourceSet.getResources()) {
                        for (EObject eObj : resource.getContents()) {
                            if (!(eObj instanceof Group)) continue;
                            group = (Group)eObj;
                            continue block2;
                        }
                    }
                    Resource ecoreRes = EMFResource.getResource((IFile)this.ecoreIFile);
                    ecoreRes.load(Collections.EMPTY_MAP);
                    EList viewpoints = group.getOwnedViewpoints();
                    Viewpoint viewpoint = (Viewpoint)viewpoints.get(0);
                    String diagramName = (String)this.getValue(KEY_DIAGRAM_NAME);
                    String rootEClassName = (String)this.getValue(KEY_DIAGRAM_ROOT_ECLASS);
                    List<EClass> allEClasses = EcoreUtil2.eAllContentsAsList((Resource)ecoreRes).stream().filter(e -> e instanceof EClass).map(e -> (EClass)e).collect(Collectors.toList());
                    List<EPackage> allEPackages = EcoreUtil2.eAllContentsAsList((Resource)ecoreRes).stream().filter(p -> p instanceof EPackage).map(p -> (EPackage)p).collect(Collectors.toList());
                    final Ecore2BasicObjectDiagramSpecification diagramBuilder = new Ecore2BasicObjectDiagramSpecification(viewpoint, diagramName, allEClasses, allEPackages, rootEClassName);
                    editingDomain.getCommandStack().execute((Command)new ChangeCommand((Notifier)group.eResource()){

                        protected void doExecute() {
                            diagramBuilder.addBasicObjectDiagram();
                        }
                    });
                }
            }
            catch (IOException e2) {
                Activator.logErrorMessage(e2.getMessage(), e2);
            }
        }
    }
}

