/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.export;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.tools.api.actions.export.ExportAction;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.ui.tools.api.dialogs.AbstractExportRepresentationsAsImagesDialog;
import org.eclipse.sirius.ui.tools.api.dialogs.ExportOneRepresentationAsImageDialog;
import org.eclipse.sirius.ui.tools.api.dialogs.ExportSeveralRepresentationsAsImagesDialog;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractExportRepresentationsAction
extends Action {
    protected AbstractExportRepresentationsAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public void run() {
        Collection repDescriptorsToExport = this.getRepresentationToExport().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!(repDescriptorsToExport = (Collection)repDescriptorsToExport.stream().filter(repDesc -> repDesc.getRepresentation() != null).collect(Collectors.toList())).isEmpty()) {
            IPath exportPath;
            DRepresentationDescriptor firstDRepDescriptorToExport = (DRepresentationDescriptor)repDescriptorsToExport.iterator().next();
            firstDRepDescriptorToExport.getRepresentation();
            Session session = this.getSession(firstDRepDescriptorToExport);
            if (session != null && (exportPath = this.getExportPath(firstDRepDescriptorToExport, session)) != null) {
                this.exportRepresentation(exportPath, repDescriptorsToExport, session);
            }
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ExportRepresentationsAction_noRepresentationsDialog_title, (String)Messages.ExportRepresentationsAction_noRepresentationsDialog_message);
        }
    }

    protected abstract Collection<DRepresentationDescriptor> getRepresentationToExport();

    protected abstract Session getSession(DRepresentationDescriptor var1);

    protected void exportRepresentation(IPath exportPath, Iterable<DRepresentationDescriptor> representationsToExport, Session session) {
        block13: {
            Shell shell = Display.getCurrent().getActiveShell();
            AbstractExportRepresentationsAsImagesDialog dialog = Iterables.size(representationsToExport) > 1 ? new ExportSeveralRepresentationsAsImagesDialog(shell, exportPath) : new ExportOneRepresentationAsImageDialog(shell, exportPath, representationsToExport.iterator().next().getName());
            if (dialog.open() == 0) {
                ArrayList<DRepresentation> dRepresentations = new ArrayList<DRepresentation>();
                for (DRepresentationDescriptor dRepresentationDescriptor : representationsToExport) {
                    dRepresentations.add(dRepresentationDescriptor.getRepresentation());
                }
                ArrayList toExport = Lists.newArrayList(dRepresentations);
                ExportAction exportAction = new ExportAction(session, toExport, dialog.getOutputPath(), dialog.getImageFormat(), dialog.isExportToHtml(), dialog.isExportDecorations());
                exportAction.setDiagramScaleLevel(dialog.getDiagramScaleLevelInPercent());
                try (ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);){
                    try {
                        pmd.run(false, false, (IRunnableWithProgress)exportAction);
                        break block13;
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof OutOfMemoryError) {
                            MessageDialog.openError((Shell)shell, (String)Messages.ExportAction_memAllocError, (String)cause.getMessage());
                        } else if (cause instanceof SizeTooLargeException) {
                            MessageDialog.openError((Shell)shell, (String)Messages.ExportAction_exportImpossibleTitle, (String)cause.getMessage());
                            SiriusPlugin.getDefault().error(Messages.ExportAction_exportError, cause);
                        } else {
                            MessageDialog.openError((Shell)shell, (String)Messages.AbstractExportRepresentationsAction_error, (String)cause.getMessage());
                        }
                        pmd.close();
                        break block13;
                    }
                    catch (InterruptedException e) {
                        MessageDialog.openInformation((Shell)shell, (String)Messages.AbstractExportRepresentationsAction_error, (String)e.getMessage());
                        pmd.close();
                        break block13;
                    }
                }
            }
            dialog.close();
        }
    }

    protected IPath getExportPath(DRepresentationDescriptor repDescriptor, Session session) {
        IPath exportPath = null;
        DRepresentation representation = repDescriptor.getRepresentation();
        if (representation != null) {
            URI representationResourceURI = repDescriptor.getRepresentation().eResource().getURI();
            URIQuery uriQuery = new URIQuery(representationResourceURI);
            Option iResourceOption = uriQuery.getCorrespondingResource();
            exportPath = iResourceOption.some() ? ((IResource)iResourceOption.get()).getParent().getLocation() : this.getExportPath(session);
        }
        return exportPath;
    }

    private IPath getExportPath(Session session) {
        String[] segments;
        String opaquePart;
        IPath exportPath = Platform.getLocation();
        URI mainSessionResourceURI = session.getSessionResource().getURI();
        URIQuery uriQuery = new URIQuery(mainSessionResourceURI);
        Option iResourceOption = uriQuery.getCorrespondingResource();
        if (iResourceOption.some()) {
            exportPath = ((IResource)iResourceOption.get()).getParent().getLocation();
        } else if (uriQuery.isInMemoryURI() && !StringUtil.isEmpty((String)(opaquePart = mainSessionResourceURI.opaquePart())) && (segments = opaquePart.split(Pattern.quote("/"))) != null && segments.length > 0) {
            String projectName = segments[0];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                exportPath = project.getLocation();
            }
        }
        return exportPath;
    }
}

