/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRendererFilter;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;

public class MenuManagerShowProcessor
implements IMenuListener2 {
    @Inject
    private EModelService modelService;
    @Inject
    private IRendererFactory rendererFactory;
    @Inject
    private MenuManagerRenderer renderer;
    @Inject
    private IContributionFactory contributionFactory;
    @Inject
    @Optional
    private Logger logger;
    protected static final String DYNAMIC_ELEMENT_STORAGE_KEY = String.valueOf(MenuManagerShowProcessor.class.getSimpleName()) + ".dynamicElements";

    private static void trace(String msg, MenuManager menuManager, MMenu menuModel) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)(String.valueOf(msg) + ": " + menuManager + ": " + menuManager.getMenu() + ": " + menuModel), null);
    }

    public void menuAboutToShow(IMenuManager manager) {
        AbstractPartRenderer obj;
        if (!(manager instanceof MenuManager)) {
            return;
        }
        MenuManager menuManager = (MenuManager)manager;
        MMenu menuModel = this.renderer.getMenuModel(menuManager);
        Menu menu = menuManager.getMenu();
        if (menuModel != null) {
            this.cleanUp(menuModel, menuManager);
        }
        if (menuModel instanceof MPopupMenu) {
            this.showPopup((MPopupMenu)menuModel);
        }
        if (!((obj = this.rendererFactory.getRenderer((MUIElement)menuModel, (Object)menu.getParent())) instanceof MenuManagerRenderer)) {
            if (Policy.DEBUG_MENUS) {
                MenuManagerShowProcessor.trace("Not the correct renderer: " + obj, menuManager, menuModel);
            }
            return;
        }
        MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
        if (menuModel.getWidget() == null) {
            renderer.bindWidget((MUIElement)menuModel, menuManager.getMenu());
        }
    }

    public void menuAboutToHide(IMenuManager manager) {
        if (!(manager instanceof MenuManager)) {
            return;
        }
        MenuManager menuManager = (MenuManager)manager;
        MMenu menuModel = this.renderer.getMenuModel(menuManager);
        if (menuModel != null) {
            this.processDynamicElements(menuModel, menuManager);
            this.showMenu(menuModel, menuManager);
        }
    }

    private void processDynamicElements(MMenu menuModel, MenuManager menuManager) {
        MMenuElement[] menuElements;
        MMenuElement[] mMenuElementArray = menuElements = menuModel.getChildren().toArray(new MMenuElement[menuModel.getChildren().size()]);
        int n = menuElements.length;
        int n2 = 0;
        while (n2 < n) {
            MMenuElement currentMenuElement = mMenuElementArray[n2];
            if (currentMenuElement instanceof MDynamicMenuContribution) {
                MDynamicMenuContribution dmc = (MDynamicMenuContribution)currentMenuElement;
                Object contribution = dmc.getObject();
                if (contribution == null) {
                    IEclipseContext context = this.modelService.getContainingContext((MUIElement)menuModel);
                    contribution = this.contributionFactory.create(dmc.getContributionURI(), context);
                    dmc.setObject(contribution);
                }
                IEclipseContext dynamicMenuContext = EclipseContextFactory.create();
                ArrayList mel = new ArrayList();
                dynamicMenuContext.set(List.class, mel);
                dynamicMenuContext.set(MDynamicMenuContribution.class, (Object)dmc);
                IEclipseContext parentContext = this.modelService.getContainingContext((MUIElement)currentMenuElement);
                Object rc = ContextInjectionFactory.invoke((Object)contribution, AboutToShow.class, (IEclipseContext)parentContext, (IEclipseContext)dynamicMenuContext, (Object)this);
                dynamicMenuContext.dispose();
                if (rc == this) {
                    if (this.logger != null) {
                        this.logger.error("Missing @AboutToShow method in " + contribution);
                    }
                } else if (mel.size() > 0) {
                    int position = 0;
                    while (position < menuModel.getChildren().size()) {
                        if (currentMenuElement == menuModel.getChildren().get(position)) {
                            ++position;
                            break;
                        }
                        ++position;
                    }
                    int j = 0;
                    while (j < mel.size()) {
                        MMenuElement menuElement = (MMenuElement)mel.get(j);
                        if (menuElement.getElementId() == null || menuElement.getElementId().length() < 1) {
                            menuElement.setElementId(String.valueOf(currentMenuElement.getElementId()) + "." + j);
                        }
                        menuModel.getChildren().add(position++, menuElement);
                        this.renderer.modelProcessSwitch(menuManager, menuElement);
                        ++j;
                    }
                    currentMenuElement.getTransientData().put(DYNAMIC_ELEMENT_STORAGE_KEY, mel);
                }
            }
            ++n2;
        }
    }

    private void cleanUp(MMenu menuModel, MenuManager menuManager) {
        if (Policy.DEBUG_MENUS) {
            MenuManagerShowProcessor.trace("\nCleaning up the dynamic menu contributions", menuManager, menuModel);
        }
        this.renderer.removeDynamicMenuContributions(menuManager, menuModel);
        if (menuManager.getRemoveAllWhenShown()) {
            if (Policy.DEBUG_MENUS) {
                MenuManagerShowProcessor.trace("\nCleaning up all of the menu model items", menuManager, menuModel);
            }
            this.renderer.cleanUp(menuModel);
            Iterator it = menuModel.getChildren().iterator();
            while (it.hasNext()) {
                MMenuElement mMenuElement = (MMenuElement)it.next();
                it.remove();
                IContributionItem ici = this.renderer.getContribution(mMenuElement);
                if (ici == null && mMenuElement instanceof MMenu) {
                    MMenu menuElement = (MMenu)mMenuElement;
                    ici = this.renderer.getManager(menuElement);
                    this.renderer.clearModelToManager(menuElement, (MenuManager)ici);
                }
                this.renderer.clearModelToContribution(mMenuElement, ici);
            }
        }
    }

    private void showPopup(MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext parentContext = popupContext.getParent();
        IEclipseContext originalChild = parentContext.getActiveChild();
        popupContext.activate();
        popupContext.set("MenuServiceFilter.original.context", (Object)originalChild);
    }

    private void showMenu(MMenu menuModel, MenuManager menuManager) {
        IEclipseContext evalContext = menuModel instanceof MContext ? ((MContext)menuModel).getContext() : this.modelService.getContainingContext((MUIElement)menuModel);
        MenuManagerRendererFilter.updateElementVisibility(menuModel, this.renderer, menuManager, evalContext, 2, true);
    }
}

