/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.env;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.PathsBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.RawEnvironmentBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IAleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public interface IAleEnvironment
extends AutoCloseable,
Closeable {
    public static FileBasedAleEnvironment fromFile(IFile file) {
        return new FileBasedAleEnvironment(file);
    }

    public static FileBasedAleEnvironment fromFile(File file) {
        return new FileBasedAleEnvironment(file);
    }

    public static IAleEnvironment fromPaths(Collection<String> metamodelPaths, Collection<String> behaviorPaths) {
        return new PathsBasedAleEnvironment(metamodelPaths, behaviorPaths);
    }

    public static IAleEnvironment fromRaw(IQueryEnvironment context, Collection<EPackage> metamodels, Collection<ParsedFile<ModelUnit>> behaviors) {
        return new RawEnvironmentBasedAleEnvironment(context, metamodels, behaviors);
    }

    public IQueryEnvironment getContext();

    public IAleInterpreter getInterpreter();

    public List<EPackage> getMetamodels();

    public IBehaviors getBehaviors();

    public LinkedHashSet<String> getBehaviorsSources();

    public LinkedHashSet<String> getMetamodelsSources();

    public List<EObject> loadModel(URI var1);

    public Resource loadResource(URI var1);

    @Override
    public void close();
}

