/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.dialect;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.dialect.AbstractRepresentationDialectServices;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.metamodel.helper.ComponentizationHelper;
import org.eclipse.sirius.business.internal.query.DRepresentationDescriptorInternalHelper;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.business.internal.dialect.NotYetOpenedDiagramAdapter;
import org.eclipse.sirius.diagram.business.internal.dialect.description.DiagramInterpretedExpressionQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.CreateViewTask;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.NavigationTask;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.DiagramImportDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.Navigation;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.diagram.tools.api.command.DiagramCommandFactoryService;
import org.eclipse.sirius.diagram.tools.internal.preferences.SiriusDiagramInternalPreferencesKeys;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class DiagramDialectServices
extends AbstractRepresentationDialectServices {
    protected boolean isSupported(DRepresentation representation) {
        return representation instanceof DDiagram;
    }

    protected boolean isSupported(DRepresentationDescriptor representationDescriptor) {
        return representationDescriptor.getDescription() instanceof DiagramDescription;
    }

    protected boolean isSupported(RepresentationDescription description) {
        return description instanceof DiagramDescription;
    }

    public boolean canCreate(EObject semantic, RepresentationDescription desc, boolean checkSelectedViewpoint) {
        Session session;
        boolean result = false;
        if (semantic != null && this.isSupported(desc) && ((session = new EObjectQuery(semantic).getSession()) == null || checkSelectedViewpoint && this.isRelatedViewpointSelected(session, desc) || !checkSelectedViewpoint)) {
            DiagramDescription diagDesc = (DiagramDescription)desc;
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
            if (accessor != null) {
                result = this.checkDomainClass(accessor, semantic, diagDesc.getDomainClass());
                boolean needsToCheckSemanticElement = true;
                if (diagDesc.getInit() == null || diagDesc.getInit().getInitialOperation() == null || diagDesc.getInit().getInitialOperation().getFirstModelOperations() == null) {
                    needsToCheckSemanticElement = false;
                }
                if (needsToCheckSemanticElement) {
                    result = result && this.checkSemanticElementCanBeFilled(accessor, semantic);
                }
            }
            result = result && this.checkPrecondition(semantic, diagDesc.getPreconditionExpression());
        }
        return result;
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, IProgressMonitor monitor) {
        DiagramDescription diagDesc = (DiagramDescription)description;
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
        DDiagramSynchronizer sync = new DDiagramSynchronizer(interpreter, diagDesc, accessor);
        sync.initDiagram(semantic, monitor);
        boolean syncOnCreation = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramInternalPreferencesKeys.PREF_SYNCHRONIZE_DIAGRAM_ON_CREATION.name(), false, null);
        sync.getDiagram().setSynchronized(syncOnCreation);
        return sync.getDiagram();
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, Session session, IProgressMonitor monitor) {
        DRepresentation diagram = null;
        try {
            monitor.beginTask(MessageFormat.format(Messages.DiagramDialectServices_createDiagramMsg, name), 6);
            monitor.subTask(MessageFormat.format(Messages.DiagramDialectServices_createDiagramMsg, name));
            diagram = this.createRepresentation(name, semantic, description, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (diagram != null) {
                DRepresentationDescriptorInternalHelper.createDRepresentationDescriptor((DRepresentation)diagram, (DAnalysisSessionImpl)((DAnalysisSessionImpl)session), (Resource)semantic.eResource(), (String)name, (String)"");
                monitor.worked(1);
                Diagram gmfDiag = DiagramDialectServices.createAndStoreGMFDiagram(session, (DSemanticDiagram)diagram);
                monitor.worked(1);
                DialectManager.INSTANCE.refresh(diagram, (IProgressMonitor)new SubProgressMonitor(monitor, 26));
                if (DisplayMode.NORMAL.equals((Object)DisplayServiceManager.INSTANCE.getMode())) {
                    DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility((DDiagram)diagram);
                    monitor.worked(1);
                }
                CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(gmfDiag);
                canonicalSynchronizer.storeViewsToArrange(true);
                canonicalSynchronizer.synchronize();
                canonicalSynchronizer.postCreation();
                monitor.worked(10);
            }
        }
        finally {
            monitor.done();
        }
        return diagram;
    }

    public static Diagram createAndStoreGMFDiagram(Session session, DSemanticDiagram diagram) {
        Diagram gmfDiag;
        DiagramCreationUtil util = new DiagramCreationUtil((DDiagram)diagram);
        if (!util.findAssociatedGMFDiagram()) {
            util.createNewGMFDiagram();
        }
        if ((gmfDiag = util.getAssociatedGMFDiagram()) != null) {
            session.getServices().putCustomData("GMF_DIAGRAMS", (EObject)diagram, (EObject)gmfDiag);
        }
        NotYetOpenedDiagramAdapter.markAsToArrange((DDiagram)diagram);
        return gmfDiag;
    }

    public void refresh(DRepresentation representation, boolean fullRefresh, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.DiagramDialectServices_refreshDiagramMsg, 10);
            DSemanticDiagram diagram = (DSemanticDiagram)representation;
            if (diagram.getDescription() != null) {
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)representation);
                ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
                DDiagramSynchronizer sync = new DDiagramSynchronizer(interpreter, diagram.getDescription(), accessor);
                sync.setDiagram(diagram);
                monitor.worked(1);
                sync.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 7));
                DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility((DDiagram)diagram);
                monitor.worked(1);
                NotificationUtil.sendNotification((EObject)diagram, (int)0, (int)5);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public Set<Viewpoint> getRequiredViewpoints(DRepresentation representation) {
        Set requiredViewpoints = super.getRequiredViewpoints(representation);
        if (representation instanceof DDiagram) {
            DDiagram dDiagram = (DDiagram)representation;
            EList activatedLayers = dDiagram.getActivatedLayers();
            for (Layer activatedLayer : activatedLayers) {
                if (activatedLayer.eIsProxy() || activatedLayer.eContainer() == null) continue;
                Viewpoint viewpoint = (Viewpoint)activatedLayer.eContainer().eContainer();
                requiredViewpoints.add(viewpoint);
            }
        }
        return requiredViewpoints;
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        if (representation instanceof DDiagram) {
            return ((DDiagram)representation).getDescription();
        }
        return null;
    }

    public void initRepresentations(Viewpoint vp, EObject semantic) {
        super.initRepresentations(semantic, vp, DiagramDescription.class);
    }

    public void initRepresentations(Viewpoint vp, EObject semantic, IProgressMonitor monitor) {
        super.initRepresentations(semantic, vp, DiagramDescription.class, monitor);
    }

    protected <T extends RepresentationDescription> void initRepresentationForElement(T representationDescription, EObject semanticElement, IProgressMonitor monitor) {
        TransactionalEditingDomain transactionalEditingDomain;
        DiagramDescription diagramDescription;
        if (representationDescription instanceof DiagramDescription && this.shouldInitializeRepresentation(semanticElement, (RepresentationDescription)(diagramDescription = (DiagramDescription)representationDescription), diagramDescription.getDomainClass()) && DialectManager.INSTANCE.canCreate(semanticElement, (RepresentationDescription)diagramDescription) && (transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)semanticElement)) != null) {
            try {
                monitor.beginTask(MessageFormat.format(Messages.DiagramDialectServices_initializeDiagramMsg, new IdentifiedElementQuery(representationDescription).getLabel()), 1);
                DCommand command = DiagramCommandFactoryService.getInstance().getNewProvider().getCommandFactory(transactionalEditingDomain).buildCreateDiagramFromDescription(diagramDescription, semanticElement, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                TransactionUtil.getEditingDomain((EObject)semanticElement).getCommandStack().execute((Command)command);
            }
            finally {
                monitor.done();
            }
        }
    }

    public void updateRepresentationsExtendedBy(Session session, Viewpoint viewpoint, boolean activated) {
        EList extensions = viewpoint.getOwnedRepresentationExtensions();
        for (DView view : session.getOwnedViews()) {
            for (DRepresentation representation : new DViewQuery(view).getLoadedRepresentations()) {
                if (!(representation instanceof DSemanticDiagram)) continue;
                for (RepresentationExtensionDescription ext : extensions) {
                    if (!ComponentizationHelper.extensionAppliesTo((RepresentationExtensionDescription)ext, (DRepresentation)representation) || !(ext instanceof DiagramExtensionDescription)) continue;
                    this.updateDiagram((DSemanticDiagram)representation, (DiagramExtensionDescription)ext, activated, session);
                }
            }
        }
    }

    private void updateDiagram(DSemanticDiagram diagram, DiagramExtensionDescription ext, boolean activated, Session session) {
        for (Layer layer : ext.getLayers()) {
            if (!(layer instanceof AdditionalLayer)) continue;
            AdditionalLayer additionalLayer = (AdditionalLayer)layer;
            List<Layer> allActivatedLayers = new DDiagramQuery((DDiagram)diagram).getAllActivatedLayers();
            Boolean shouldChangeLayerActivation = activated && !allActivatedLayers.contains(additionalLayer);
            shouldChangeLayerActivation = shouldChangeLayerActivation != false || !activated && allActivatedLayers.contains(additionalLayer);
            if (!(shouldChangeLayerActivation = Boolean.valueOf(shouldChangeLayerActivation != false && (!additionalLayer.isOptional() || additionalLayer.isActiveByDefault()))).booleanValue()) continue;
            new ChangeLayerActivationCommand(session.getTransactionalEditingDomain(), (DDiagram)diagram, (Layer)additionalLayer, (IProgressMonitor)new NullProgressMonitor()).execute();
        }
    }

    public IInterpretedExpressionQuery createInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        return new DiagramInterpretedExpressionQuery(target, feature);
    }

    public boolean handles(RepresentationDescription representationDescription) {
        return representationDescription instanceof DiagramDescription || representationDescription instanceof DiagramImportDescription;
    }

    public boolean handles(RepresentationExtensionDescription representationExtensionDescription) {
        return representationExtensionDescription instanceof DiagramExtensionDescription;
    }

    public void invalidateMappingCache() {
        DiagramDescriptionMappingsRegistry.INSTANCE.computeMappings();
    }

    public Option<? extends AbstractCommandTask> createTask(CommandContext context, ModelAccessor extPackage, ModelOperation op, Session session, UICallBack uiCallback) {
        Option task = Options.newNone();
        if (op instanceof CreateView) {
            CreateView createView = (CreateView)op;
            task = Options.newSome((Object)((Object)new CreateViewTask(context, extPackage, createView, session.getInterpreter())));
        } else if (op instanceof Navigation) {
            Navigation doubleClickNavigation = (Navigation)op;
            task = Options.newSome((Object)((Object)new NavigationTask(context, extPackage, doubleClickNavigation, session.getInterpreter(), uiCallback)));
        }
        return task;
    }

    public boolean allowsEStructuralFeatureCustomization(EObject element) {
        if (element instanceof StyleDescription || element.eContainer() instanceof StyleDescription) {
            EPackage ePackage = element.eClass().getEPackage();
            return ePackage == StylePackage.eINSTANCE || ePackage == org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE;
        }
        return false;
    }

    public void refreshImpactedElements(DRepresentation representation, Collection<Notification> notifications, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.DiagramDialectServices_refreshDiagramMsg, 10);
            DSemanticDiagram diagram = (DSemanticDiagram)representation;
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(diagram.getTarget());
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
            Set<DDiagramElement> diagramElements = this.getDiagramElementsToRefresh(notifications, diagram);
            monitor.worked(2);
            DDiagramElementSynchronizer sync = new DDiagramElementSynchronizer(diagram, interpreter, accessor);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 8);
            try {
                subMonitor.beginTask(Messages.DiagramDialectServices_refreshImactedElementsMsg, diagramElements.size());
                for (DDiagramElement diagramElement : diagramElements) {
                    sync.refresh(diagramElement);
                    subMonitor.worked(1);
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private Set<DDiagramElement> getDiagramElementsToRefresh(Collection<Notification> notifications, DSemanticDiagram diagram) {
        HashSet<DDiagramElement> diagramElementsToRefresh = new HashSet<DDiagramElement>();
        Session session = new EObjectQuery(diagram.getTarget()).getSession();
        if (session != null) {
            ECrossReferenceAdapter xref = session.getSemanticCrossReferencer();
            HashMap<EObject, ArrayList<Notification>> notificationsByNotifer = new HashMap<EObject, ArrayList<Notification>>();
            for (Notification notification : notifications) {
                Object notifier = notification.getNotifier();
                if (!(notifier instanceof EObject)) continue;
                EObject eObjectNotifier = (EObject)notifier;
                ArrayList<Notification> currentNotifications = (ArrayList<Notification>)notificationsByNotifer.get(eObjectNotifier);
                if (currentNotifications == null) {
                    currentNotifications = new ArrayList<Notification>();
                    notificationsByNotifer.put(eObjectNotifier, currentNotifications);
                }
                currentNotifications.add(notification);
            }
            Iterable removeNotificationsIterable = Iterables.filter(notifications, (Predicate)new Predicate<Notification>(){

                public boolean apply(Notification notification) {
                    boolean isRemoveNotif;
                    boolean bl = isRemoveNotif = notification.getEventType() == 4 || notification.getEventType() == 6;
                    return isRemoveNotif && !new NotificationQuery(notification).isTransientNotification();
                }
            });
            ArrayList<EObject> changedNotifiers = new ArrayList<EObject>();
            for (Map.Entry entry : notificationsByNotifer.entrySet()) {
                if (!Iterables.any((Iterable)((Iterable)entry.getValue()), (Predicate)new Predicate<Notification>(){

                    public boolean apply(Notification notification) {
                        boolean expecetedEventType = notification.getEventType() == 1 || notification.getEventType() == 2;
                        expecetedEventType = expecetedEventType || notification.getEventType() == 3 || notification.getEventType() == 5 || notification.getEventType() == 7;
                        return expecetedEventType;
                    }
                })) continue;
                changedNotifiers.add((EObject)entry.getKey());
            }
            for (final EObject changedNotifier : changedNotifiers) {
                if (Iterables.any((Iterable)removeNotificationsIterable, (Predicate)new Predicate<Notification>(){

                    public boolean apply(Notification notification) {
                        boolean isRemoveOfCurrentElement;
                        boolean bl = isRemoveOfCurrentElement = notification.getEventType() == 4 && changedNotifier.equals(notification.getOldValue());
                        if (isRemoveOfCurrentElement) {
                            return true;
                        }
                        return notification.getEventType() == 6 && notification.getOldValue() instanceof List && ((List)notification.getOldValue()).contains(changedNotifier);
                    }
                })) continue;
                diagramElementsToRefresh.addAll(this.getDiagramElementsToRefresh(changedNotifier, diagram, xref));
            }
        }
        return diagramElementsToRefresh;
    }

    private Set<DDiagramElement> getDiagramElementsToRefresh(EObject notifier, DSemanticDiagram diagram, ECrossReferenceAdapter xref) {
        HashSet<DDiagramElement> diagramElementsToRefresh = new HashSet<DDiagramElement>();
        Collection inverseReferencers = new EObjectQuery(notifier, xref).getInverseReferences(AbstractRepresentationDialectServices.REPRESENTATION_ELEMENTS_INVERSE_REFERENCES);
        for (EObject inverseReferencer : inverseReferencers) {
            DDiagramElement diagramElement;
            if (!(inverseReferencer instanceof DDiagramElement) || !this.isContainedWithinCurrentDiagram(diagramElement = (DDiagramElement)inverseReferencer, diagram)) continue;
            diagramElementsToRefresh.add(diagramElement);
        }
        return diagramElementsToRefresh;
    }

    private boolean isContainedWithinCurrentDiagram(DDiagramElement diagramElement, DSemanticDiagram diagram) {
        return diagram == new DRepresentationElementQuery((DRepresentationElement)diagramElement).getParentRepresentation();
    }
}

