/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.CustomStyle;
import org.eclipse.sirius.diagram.Dot;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.GaugeCompositeStyle;
import org.eclipse.sirius.diagram.Lozenge;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.Note;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.util.DiagramSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.RGBValues;

public class NodeStyleQuery {
    private NodeStyle nodeStyle;

    public NodeStyleQuery(NodeStyle nodeStyle) {
        this.nodeStyle = nodeStyle;
    }

    public Option<RGBValues> getBackgroundColor() {
        RGBValues color = (RGBValues)new GetBackgroundColorForNodeStyleSwitch().doSwitch((EObject)this.nodeStyle);
        if (color == null) {
            return Options.newNone();
        }
        return Options.newSome((Object)color);
    }

    public Option<RGBValues> getLabelColor() {
        RGBValues color = this.nodeStyle.getLabelColor();
        if (color == null) {
            return Options.newNone();
        }
        return Options.newSome((Object)color);
    }

    private static final class GetBackgroundColorForNodeStyleSwitch
    extends DiagramSwitch<RGBValues> {
        private GetBackgroundColorForNodeStyleSwitch() {
        }

        public RGBValues caseNodeStyle(NodeStyle object) {
            return null;
        }

        public RGBValues caseBundledImage(BundledImage object) {
            return object.getColor();
        }

        public RGBValues caseCustomStyle(CustomStyle object) {
            return null;
        }

        public RGBValues caseDot(Dot object) {
            return object.getBackgroundColor();
        }

        public RGBValues caseEllipse(Ellipse object) {
            return object.getColor();
        }

        public RGBValues caseGaugeCompositeStyle(GaugeCompositeStyle object) {
            return null;
        }

        public RGBValues caseLozenge(Lozenge object) {
            return object.getColor();
        }

        public RGBValues caseNote(Note object) {
            return object.getColor();
        }

        public RGBValues caseSquare(Square object) {
            return object.getColor();
        }

        public RGBValues caseWorkspaceImage(WorkspaceImage object) {
            return null;
        }
    }
}

