/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.refactoring;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.ide.Activator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenamePathsInDslFilesChange
extends Change {
    private final IFile dslFile;
    private final Collection<String> behaviors;
    private final Collection<String> metamodels;

    public RenamePathsInDslFilesChange(IFile dslFile, Collection<String> behaviors, Collection<String> metamodels) {
        this.dslFile = Objects.requireNonNull(dslFile, "dslFile");
        this.behaviors = Objects.requireNonNull(behaviors, "behaviors");
        this.metamodels = Objects.requireNonNull(metamodels, "metamodels");
    }

    public String getName() {
        return "Update paths in '" + this.dslFile.getFullPath() + "'";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Object getModifiedElement() {
        return this.dslFile;
    }

    public Object[] getAffectedObjects() {
        return new Object[]{this.dslFile};
    }

    public Change perform(IProgressMonitor monitor) throws CoreException {
        block16: {
            try {
                RenamePathsInDslFilesChange renamePathsInDslFilesChange;
                block15: {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    FileBasedAleEnvironment dsl = IAleEnvironment.fromFile((IFile)this.dslFile);
                    try {
                        RenamePathsInDslFilesChange undo;
                        LinkedHashSet<String> currentBehaviors = new LinkedHashSet<String>(dsl.getBehaviorsSources());
                        LinkedHashSet<String> currentMetamodels = new LinkedHashSet<String>(dsl.getMetamodelsSources());
                        dsl.save(IAleEnvironment.fromPaths(this.metamodels, this.behaviors));
                        renamePathsInDslFilesChange = undo = new RenamePathsInDslFilesChange(this.dslFile, currentBehaviors, currentMetamodels);
                        if (dsl == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (dsl != null) {
                                    dsl.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            Activator.warn("Unable to rename paths in " + this.dslFile.getFullPath(), e);
                            break block16;
                        }
                    }
                    dsl.close();
                }
                return renamePathsInDslFilesChange;
            }
            finally {
                monitor.done();
            }
        }
        return null;
    }
}

