/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetDefinitionDocumentTools {
    private static Comparator<Element> elementAttributesComparator = (o1, o2) -> {
        NamedNodeMap expectedAttrs = o1.getAttributes();
        NamedNodeMap actualAttrs = o2.getAttributes();
        if (expectedAttrs.getLength() != actualAttrs.getLength()) {
            return expectedAttrs.getLength() - actualAttrs.getLength();
        }
        int i = 0;
        while (i < expectedAttrs.getLength()) {
            Attr expectedAttr = (Attr)expectedAttrs.item(i);
            Attr actualAttr = null;
            actualAttr = expectedAttr.getNamespaceURI() == null ? (Attr)actualAttrs.getNamedItem(expectedAttr.getName()) : (Attr)actualAttrs.getNamedItemNS(expectedAttr.getNamespaceURI(), expectedAttr.getLocalName());
            if (actualAttr == null) {
                return -1;
            }
            int comparedValue = expectedAttr.getValue().compareTo(actualAttr.getValue());
            if (comparedValue != 0) {
                return comparedValue;
            }
            ++i;
        }
        return 0;
    };

    public static Element getChildElement(Element parent, String ... childNames) {
        if (parent != null && childNames.length > 0) {
            Element childNode = null;
            NodeList list = parent.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node instanceof Element && node.getNodeName().equalsIgnoreCase(childNames[0])) {
                    childNode = (Element)node;
                    break;
                }
                ++i;
            }
            if (childNode == null) {
                Document parentDocument = parent.getOwnerDocument();
                childNode = parentDocument.createElement(childNames[0]);
                TargetDefinitionDocumentTools.addChildWithIndent(parent, childNode);
            }
            if (childNames.length > 1) {
                return TargetDefinitionDocumentTools.getChildElement(childNode, Arrays.copyOfRange(childNames, 1, childNames.length));
            }
            return childNode;
        }
        return null;
    }

    public static void addChildWithIndent(Node parent, Node child) {
        Node lastChild = parent.getLastChild();
        if (TargetDefinitionDocumentTools.isWhitespaceNode(lastChild)) {
            parent.removeChild(lastChild);
        }
        TargetDefinitionDocumentTools.appendTextNode(parent, true);
        parent.appendChild(child);
        int initalLength = child.getChildNodes().getLength();
        int editIndex = 0;
        int i = 0;
        while (i < initalLength) {
            Node node = child.getChildNodes().item(editIndex);
            if (node instanceof Element) {
                TargetDefinitionDocumentTools.addChildWithIndent(child, child.removeChild(node));
            } else {
                ++editIndex;
            }
            ++i;
        }
        TargetDefinitionDocumentTools.appendTextNode(parent, false);
    }

    public static void updateElements(Element parentElement, List<Element> oldElements, List<Element> newElements, Comparator<Element> comparator) {
        if (oldElements == null) {
            oldElements = new ArrayList<Element>();
            NodeList nodes = parentElement.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    oldElements.add((Element)node);
                }
                ++i;
            }
        }
        for (Element element : oldElements) {
            boolean matchFound = false;
            if (comparator != null) {
                int j = 0;
                while (j < newElements.size()) {
                    if (comparator.compare(element, newElements.get(j)) == 0) {
                        if (elementAttributesComparator.compare(element, newElements.get(j)) != 0) {
                            parentElement.replaceChild(parentElement.getOwnerDocument().importNode(newElements.get(j), true), element);
                        }
                        newElements.remove(j);
                        matchFound = true;
                        break;
                    }
                    ++j;
                }
            }
            if (matchFound) continue;
            TargetDefinitionDocumentTools.removeChildAndWhitespace(element);
        }
        if (!newElements.isEmpty()) {
            Node lastChild = parentElement.getLastChild();
            if (TargetDefinitionDocumentTools.isWhitespaceNode(lastChild)) {
                parentElement.removeChild(lastChild);
            }
            newElements.stream().forEach(element2 -> TargetDefinitionDocumentTools.addChildWithIndent(parentElement, parentElement.getOwnerDocument().importNode((Node)element2, true)));
        }
    }

    private static void appendTextNode(Node parent, boolean addIndent) {
        Node previousSibling;
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors");
        boolean spacesForTabs = preferences.getBoolean("spacesForTabs", false);
        String newLineString = "\n";
        if (addIndent) {
            if (spacesForTabs) {
                int tabWidth = preferences.getInt("tabWidth", 4);
                char[] chars = new char[tabWidth];
                Arrays.fill(chars, ' ');
                newLineString = String.valueOf(newLineString) + new String(chars);
            } else {
                newLineString = String.valueOf(newLineString) + "\t";
            }
        }
        if (TargetDefinitionDocumentTools.isWhitespaceNode(previousSibling = parent.getPreviousSibling())) {
            String textContentString = previousSibling.getTextContent();
            int indexOfLastNewLine = Math.max(textContentString.lastIndexOf(10), textContentString.lastIndexOf(13));
            newLineString = indexOfLastNewLine >= 0 ? String.valueOf(newLineString) + textContentString.substring(indexOfLastNewLine + 1) : String.valueOf(newLineString) + textContentString;
        }
        parent.appendChild(parent.getOwnerDocument().createTextNode(newLineString));
    }

    public static boolean removeElement(Element parent, String ... childNames) {
        if (parent != null && childNames.length > 0) {
            boolean doesFirstChildExist;
            Element childNode = null;
            boolean parentHasOtherChildren = false;
            NodeList list = parent.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node instanceof Element) {
                    if (childNode == null && node.getNodeName().equalsIgnoreCase(childNames[0])) {
                        childNode = (Element)node;
                        if (parentHasOtherChildren) {
                            break;
                        }
                    } else {
                        parentHasOtherChildren = true;
                        if (childNode != null) break;
                    }
                }
                ++i;
            }
            boolean bl = doesFirstChildExist = childNode != null;
            if (doesFirstChildExist) {
                if (childNames.length > 1) {
                    doesFirstChildExist = !TargetDefinitionDocumentTools.removeElement(childNode, Arrays.copyOfRange(childNames, 1, childNames.length));
                } else {
                    TargetDefinitionDocumentTools.removeChildAndWhitespace(childNode);
                    doesFirstChildExist = false;
                }
            }
            if (!parentHasOtherChildren && !doesFirstChildExist && parent != parent.getOwnerDocument().getDocumentElement()) {
                if (parent.getParentNode() != null) {
                    TargetDefinitionDocumentTools.removeChildAndWhitespace(parent);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static void removeChildAndWhitespace(Node child) {
        if (child.getParentNode() == null) {
            return;
        }
        Node previousNode = child.getPreviousSibling();
        if (TargetDefinitionDocumentTools.isWhitespaceNode(previousNode)) {
            child.getParentNode().removeChild(previousNode);
        }
        child.getParentNode().removeChild(child);
    }

    private static boolean isWhitespaceNode(Node node) {
        return node != null && node.getNodeType() == 3 && node.getTextContent().matches("[\\n\\r\\s]+");
    }
}

