/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;

public class ArrangeSelectionLayoutProvider
extends AbstractLayoutProvider {
    private AbstractLayoutProvider initialLayoutProvider;
    private ArrayList<IDiagramElementEditPart> notSelectedShapeNodeEditPartAndUnpinned;
    private Predicate<EditPart> editPartIsNotSelected = new Predicate<EditPart>(){

        public boolean apply(EditPart input) {
            return input.getSelected() == 0;
        }
    };
    private Predicate<IDiagramElementEditPart> diagramElementEditPartIsUnpinned = new Predicate<IDiagramElementEditPart>(){

        public boolean apply(IDiagramElementEditPart input) {
            DDiagramElement diagramElement = input.resolveDiagramElement();
            if (diagramElement instanceof DDiagramElement) {
                return !new PinHelper().isPinned(diagramElement);
            }
            return false;
        }
    };

    public ArrangeSelectionLayoutProvider(AbstractLayoutProvider clp) {
        this.initialLayoutProvider = clp;
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        IGraphicalEditPart igep;
        ArrayList topLevelEditParts;
        LinkedList selectedObjectsLinkedList;
        if (selectedObjects.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        IAdaptable updatedLayoutHint = layoutHint;
        CompoundCommand result = new CompoundCommand();
        boolean arrangeIsArrangeSelection = false;
        if (selectedObjects instanceof LinkedList && (selectedObjectsLinkedList = (LinkedList)selectedObjects).get(0) instanceof IGraphicalEditPart && (arrangeIsArrangeSelection = this.validateArrangeIsArrangeSelection(selectedObjectsLinkedList, topLevelEditParts = Lists.newArrayList((Iterable)Iterables.filter((Iterable)(igep = (IGraphicalEditPart)selectedObjectsLinkedList.get(0)).getParent().getChildren(), ShapeNodeEditPart.class))))) {
            ArrayList notSelectedShapeNodeEditPart = Lists.newArrayList((Iterable)Iterables.filter((Iterable)topLevelEditParts, this.editPartIsNotSelected));
            notSelectedShapeNodeEditPart.removeAll(selectedObjectsLinkedList);
            this.notSelectedShapeNodeEditPartAndUnpinned = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)notSelectedShapeNodeEditPart, IDiagramElementEditPart.class), this.diagramElementEditPartIsUnpinned));
            this.addChildrenToNotSelectedUnpinnedList(notSelectedShapeNodeEditPart);
            RootEditPart root = igep.getRoot();
            if (root.getChildren().size() == 1 && root.getChildren().get(0) instanceof DiagramEditPart) {
                this.addEdgesToNotSelectedUnpinnedList((DiagramEditPart)root.getChildren().get(0));
            }
            final IAdaptable originalHint = layoutHint;
            updatedLayoutHint = new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (Collection.class.equals((Object)adapter)) {
                        return ArrangeSelectionLayoutProvider.this.notSelectedShapeNodeEditPartAndUnpinned;
                    }
                    return originalHint.getAdapter(adapter);
                }
            };
            selectedObjectsLinkedList.clear();
            selectedObjectsLinkedList.addAll(topLevelEditParts);
        }
        result.add(this.lauchPrimaryArrangeAll(selectedObjects, updatedLayoutHint));
        if (this.notSelectedShapeNodeEditPartAndUnpinned != null) {
            this.notSelectedShapeNodeEditPartAndUnpinned.clear();
        }
        return result;
    }

    private void addChildrenToNotSelectedUnpinnedList(Collection<? extends EditPart> notSelectedParent) {
        for (EditPart editPart : notSelectedParent) {
            ArrayList notSelectedChildrenShapeNodeEditPart = Lists.newArrayList((Iterable)Iterables.filter((Iterable)editPart.getChildren(), this.editPartIsNotSelected));
            if (notSelectedChildrenShapeNodeEditPart.isEmpty()) continue;
            this.notSelectedShapeNodeEditPartAndUnpinned.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)notSelectedChildrenShapeNodeEditPart, ShapeNodeEditPart.class), IDiagramElementEditPart.class), this.diagramElementEditPartIsUnpinned)));
            this.addChildrenToNotSelectedUnpinnedList(notSelectedChildrenShapeNodeEditPart);
        }
    }

    private void addEdgesToNotSelectedUnpinnedList(DiagramEditPart diagramEditPart) {
        for (Object connection : diagramEditPart.getConnections()) {
            DEdgeEditPart dEdgeEditPart;
            if (!(connection instanceof DEdgeEditPart) || !this.isPinnedOrConsiderAs((dEdgeEditPart = (DEdgeEditPart)connection).getSource(), this.notSelectedShapeNodeEditPartAndUnpinned) || !this.isPinnedOrConsiderAs(dEdgeEditPart.getTarget(), this.notSelectedShapeNodeEditPartAndUnpinned)) continue;
            this.notSelectedShapeNodeEditPartAndUnpinned.add(dEdgeEditPart);
        }
    }

    protected boolean isPinnedOrConsiderAs(EditPart editPart, List<IDiagramElementEditPart> editPartsConsiderAsPinned) {
        return editPart instanceof IGraphicalEditPart && (this.isPinned((IGraphicalEditPart)editPart) || editPartsConsiderAsPinned.contains(editPart));
    }

    private boolean validateArrangeIsArrangeSelection(LinkedList<?> selectedObjects, List diagramTopElements) {
        boolean result = selectedObjects.size() != diagramTopElements.size() || !selectedObjects.containsAll(diagramTopElements);
        return result;
    }

    protected Command lauchPrimaryArrangeAll(List selectedObjects, IAdaptable layoutHint) {
        return this.initialLayoutProvider.layoutEditParts(selectedObjects, layoutHint);
    }
}

