/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.api.engine_addon;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;

public class EngineAddonSortingRule {
    protected IEngineAddon owner;
    protected EngineEvent event;
    protected Priority priority;
    protected List<String> addonsWithTags;

    public EngineAddonSortingRule(IEngineAddon owner, EngineEvent event, Priority priority, List<String> addonsWithTags) {
        this.owner = owner;
        this.event = event;
        this.priority = priority;
        this.addonsWithTags = addonsWithTags;
    }

    public EngineEvent getEvent() {
        return this.event;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public List<String> getAddonsWithTags() {
        return this.addonsWithTags;
    }

    public String toReadableString() {
        return String.valueOf(this.owner.getAddonID()) + " " + (Object)((Object)this.priority) + " " + this.addonsWithTags.stream().collect(Collectors.joining(", ", "[", "]")) + " for " + (Object)((Object)this.event);
    }

    public static enum EngineEvent {
        engineAboutToStart,
        engineStarted,
        engineInitialized,
        engineAboutToStop,
        engineStopped,
        engineAboutToDispose,
        aboutToSelectStep,
        proposedStepsChanged,
        stepSelected,
        aboutToExecuteStep,
        stepExecuted,
        engineStatusChanged;

    }

    public static enum Priority {
        BEFORE,
        AFTER;

    }
}

